@echo off
set pid=%1
set oldDir=%2
set newDir=%3
set backupDir=%4
set oldDir=%oldDir:"=%
set apiDir=%oldDir%api
set licenseDir=%oldDir%license
set repoDir=%oldDir%repository
set logDir=%oldDir%tools\log
set libDir=%oldDir%tools\lib

echo Executing final SDK upgrade steps...

:waitforpid
tasklist /fi "pid eq %1" 2>nul | find "%1" >nul
if %ERRORLEVEL%==0 (
    timeout /t 2 /nobreak >nul
    goto :waitforpid
)

echo Removing old content...
call:wipeoutFolder "%apiDir%"
call:wipeoutFolder "%licenseDir%"
call:wipeoutFolder "%repoDir%"
call:wipeoutFolder "%logDir%"
call:wipeoutFolder "%libDir%"

echo Upgrading with new content...
xcopy /Y /E %3 %2 >nul
if %ERRORLEVEL% GTR 0 (
	 echo "Cannot complete SDK upgrade. Retrieve the old SDK manually from %backupDir%."
	 pause
	 exit 1
	 )

echo Removing temporary files...
rmdir /S /Q %3

echo SDK Upgrade is complete!
timeout /t 3 /nobreak >nul
exit
goto :EOF

:wipeoutFolder
SETLOCAL
del /S /Q "%~1" >nul
if %ERRORLEVEL% GTR 0 (
	 echo "A critical error occurred while trying to clear outdated files in user's SDK. Backup is located in %backupDir%."
	 pause
	 exit 1
	 )
EXIT /B 0
ENDLOCAL
