/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.auditlog;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.WithRuntimeDependencies;
import com.sap.cloud.sdk.cloudplatform.auditlog.exception.AuditLogAccessException;
import com.sap.cloud.sdk.cloudplatform.exception.DependencyNotFoundException;

/**
 * Audit log facade used with the Neo platform.
 */
public class ScpNeoAuditLogFacade implements AuditLogFacade, WithRuntimeDependencies
{
    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public Class<? extends AuditLog> getAuditLogClass()
    {
        return ScpNeoAuditLog.class;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void assertRuntimeDependenciesExist()
        throws DependencyNotFoundException
    {
        try {
            Class.forName("com.sap.cloud.auditlog.extension.AuditLogMessageExtensionFactory");
        }
        catch( final ClassNotFoundException e ) {
            throw new DependencyNotFoundException(
                "Failed to instantiate "
                    + ScpNeoAuditLog.class.getSimpleName()
                    + ". Please make sure to use the local SAP Cloud Platform Neo runtime.",
                e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public AuditLog getAuditLog()
        throws AuditLogAccessException
    {
        assertRuntimeDependenciesExist();
        return new ScpNeoAuditLog();
    }
}
