/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.auditlog;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.exception.ObjectLookupFailedException;
import com.sap.cloud.sdk.cloudplatform.naming.JndiLookupAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.AbstractRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;

/**
 * Implementation of {@link AbstractRequestContextListener} that performs the JNDI lookup of the connectivity
 * configuration and authentication header service objects on SAP CP Neo.
 */
public class ScpNeoAuditLogRequestContextListener extends AbstractRequestContextListener
{
    public static final String PROPERTY_AUDIT_LOG_MESSAGE_FACTORY =
        ScpNeoAuditLogRequestContextListener.class.getName() + ":auditLogMessageFactory";

    static final String JNDI_NAME_AUDIT_LOG_MESSAGE_FACTORY = "java:comp/env/AuditLogExtension";

    @Override
    public int getPriority()
    {
        return DefaultPriorities.CUSTOM_LISTENER + 2;
    }

    @Nonnull
    @Override
    protected Map<String, Property<?>> getProperties( @Nonnull final RequestContext requestContext )
    {
        final Map<String, Property<?>> properties = new HashMap<>();

        Property<?> property;
        try {
            property = Property.ofValue(JndiLookupAccessor.lookup(JNDI_NAME_AUDIT_LOG_MESSAGE_FACTORY));
        }
        catch( final ObjectLookupFailedException e ) {
            property = Property.ofException(e);
        }

        properties.put(PROPERTY_AUDIT_LOG_MESSAGE_FACTORY, property);
        return properties;
    }
}
