/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.auditlog;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.sap.cloud.auditlog.AuditedObject;
import com.sap.cloud.auditlog.exception.AuditLogWriteException;
import com.sap.cloud.auditlog.extension.AuditLogMessageExtension;
import com.sap.cloud.auditlog.extension.AuditLogMessageExtensionFactory;
import com.sap.cloud.auditlog.extension.ConfigurationChangeAuditMessageExtension;
import com.sap.cloud.auditlog.extension.DataModificationAuditMessageExtension;
import com.sap.cloud.auditlog.extension.ReadAccessAuditMessageExtension;
import com.sap.cloud.auditlog.extension.SecurityEventAuditMessageExtension;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessRequester;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessedAttribute;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLog;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataObject;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataSubject;
import com.sap.cloud.sdk.cloudplatform.auditlog.ScpNeoAuditLogRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.auditlog.exception.AuditLogAccessException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextExecutor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ScpNeoAuditLog
implements AuditLog {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpNeoAuditLog.class);
    static final String ACTION_SECURITY_EVENT_BEGIN = "securityEventBegin";
    static final String ACTION_SECURITY_EVENT = "securityEvent";
    static final String ACTION_SECURITY_EVENT_FAILED = "securityEventFailed";
    static final String ATTRIBUTE_CALLER_CHANNEL = "caller_channel";
    static final String ATTRIBUTE_LOG_MESSAGE = "message";
    static final String ATTRIBUTE_ERROR_MESSAGE = "errorMessage";
    static final String ATTRIBUTE_STACK_TRACE = "errorStackTrace";
    static final String SUCCESSFUL_OPERATION = "[successfully modified]";
    static final String FAILED_OPERATION = "[modification failed]";
    private final AuditLogMessageExtensionFactory auditLogExtensionMessageFactory;

    public ScpNeoAuditLog() throws AuditLogAccessException {
        this.auditLogExtensionMessageFactory = this.getAuditLogMessageExtensionFactory();
    }

    public ScpNeoAuditLog(@Nonnull AuditLogMessageExtensionFactory auditLogExtensionMessageFactory) {
        this.auditLogExtensionMessageFactory = auditLogExtensionMessageFactory;
    }

    private AuditLogMessageExtensionFactory getAuditLogMessageExtensionFactory() throws AuditLogAccessException {
        Optional requestContext = RequestContextAccessor.getCurrentRequestContext();
        if (!requestContext.isPresent()) {
            throw new AuditLogAccessException("Failed to get " + AuditLogMessageExtensionFactory.class.getSimpleName() + ": no " + RequestContext.class.getSimpleName() + " available. Have you correctly configured a " + RequestContextServletFilter.class.getSimpleName() + " or have you wrapped your logic in a " + RequestContextExecutor.class.getSimpleName() + " when executing background tasks that are not triggered by a request?");
        }
        try {
            Optional property = ((RequestContext)requestContext.get()).getProperty(ScpNeoAuditLogRequestContextListener.PROPERTY_AUDIT_LOG_MESSAGE_FACTORY);
            if (!property.isPresent()) {
                throw new AuditLogAccessException("Failed to get " + AuditLogMessageExtensionFactory.class.getSimpleName() + ": " + RequestContext.class.getSimpleName() + " property \"" + ScpNeoAuditLogRequestContextListener.PROPERTY_AUDIT_LOG_MESSAGE_FACTORY + "\" is not present. Please ensure that " + ScpNeoAuditLogRequestContextListener.class.getSimpleName() + " is available on the class path.");
            }
            Exception exception = ((Property)property.get()).getException();
            if (exception != null) {
                throw new AuditLogAccessException("Failed to get " + AuditLogMessageExtensionFactory.class.getSimpleName() + ".", (Throwable)exception);
            }
            return (AuditLogMessageExtensionFactory)((Property)property.get()).getValue();
        }
        catch (RequestContextPropertyException e) {
            throw new AuditLogAccessException("Failed to get " + AuditLogMessageExtensionFactory.class.getSimpleName() + ": failed to get " + RequestContext.class.getSimpleName() + " property.", (Throwable)e);
        }
    }

    public void logSecurityEventBeginning(@Nonnull AccessRequester initiator, @Nullable String message) {
        this.logSecurityEvent(true, initiator, message, null);
    }

    public void logSecurityEvent(@Nonnull AccessRequester initiator, @Nullable String message, @Nullable Throwable throwable) {
        this.logSecurityEvent(false, initiator, message, throwable);
    }

    private void logSecurityEvent(boolean isBeginning, @Nonnull AccessRequester initiator, @Nullable String message, @Nullable Throwable throwable) {
        SecurityEventAuditMessageExtension auditLogEntry = (SecurityEventAuditMessageExtension)this.auditLogExtensionMessageFactory.createAuditLogMessageExtension(SecurityEventAuditMessageExtension.class);
        if (throwable == null) {
            auditLogEntry.setAction(isBeginning ? ACTION_SECURITY_EVENT_BEGIN : ACTION_SECURITY_EVENT);
        } else {
            auditLogEntry.setAction(ACTION_SECURITY_EVENT_FAILED);
        }
        if (!Strings.isNullOrEmpty((String)message)) {
            auditLogEntry.setMessage(message);
        }
        this.fillCommonAttributesAndLog((AuditLogMessageExtension)auditLogEntry, initiator, throwable);
    }

    public void logConfigChangeBeginning(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nullable Iterable<AccessedAttribute> attributesAffected) {
        this.logConfigChange(true, initiator, object, attributesAffected, null);
    }

    public void logConfigChange(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        this.logConfigChange(false, initiator, object, attributesAffected, error);
    }

    private void logConfigChange(boolean isBeginning, @Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        ConfigurationChangeAuditMessageExtension auditLogEntry = (ConfigurationChangeAuditMessageExtension)this.auditLogExtensionMessageFactory.createAuditLogMessageExtension(ConfigurationChangeAuditMessageExtension.class);
        if (error == null) {
            auditLogEntry.setAction(isBeginning ? "aboutToUpdate" : "update");
        } else {
            auditLogEntry.setAction("updateFailed");
        }
        auditLogEntry.setObject(this.convertAuditedObject(object));
        if (attributesAffected != null) {
            for (AccessedAttribute attribute : attributesAffected) {
                auditLogEntry.addChangedValues(attribute.getIdentifier(), String.valueOf(attribute.getOldValue()), String.valueOf(attribute.getNewValue()));
            }
        }
        this.fillCommonAttributesAndLog((AuditLogMessageExtension)auditLogEntry, initiator, error);
    }

    public void logDataReadAttempt(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected) {
        this.logDataRead(true, initiator, object, subject, attributesAffected, null);
    }

    public void logDataRead(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        this.logDataRead(false, initiator, object, subject, attributesAffected, error);
    }

    private void logDataRead(boolean isAttempting, @Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        ReadAccessAuditMessageExtension auditLogEntry = (ReadAccessAuditMessageExtension)this.auditLogExtensionMessageFactory.createAuditLogMessageExtension(ReadAccessAuditMessageExtension.class);
        if (error == null) {
            auditLogEntry.setAction(isAttempting ? "about_to_read" : "read");
        } else {
            auditLogEntry.setAction("read-attempt");
        }
        auditLogEntry.setObject(this.convertAuditedObject(object));
        auditLogEntry.setDataSubject(this.convertAuditedSubject(subject));
        if (attributesAffected != null) {
            for (AccessedAttribute attribute : attributesAffected) {
                auditLogEntry.addObjectAttribute(attribute.getIdentifier(), String.valueOf(attribute.getOldValue()));
            }
        }
        this.fillCommonAttributesAndLog((AuditLogMessageExtension)auditLogEntry, initiator, error);
    }

    public void logDataWriteAttempt(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected) {
        this.logDataWrite(true, initiator, object, subject, attributesAffected, null);
    }

    public void logDataWrite(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        this.logDataWrite(false, initiator, object, subject, attributesAffected, error);
    }

    private void logDataWrite(boolean isAttempting, @Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        DataModificationAuditMessageExtension auditLogEntry = (DataModificationAuditMessageExtension)this.auditLogExtensionMessageFactory.createAuditLogMessageExtension(DataModificationAuditMessageExtension.class);
        if (error == null) {
            auditLogEntry.setAction(isAttempting ? "aboutToUpdate" : "update");
        } else {
            auditLogEntry.setAction("updateFailed");
        }
        auditLogEntry.setObject(this.convertAuditedObject(object));
        auditLogEntry.setDataSubject(this.convertAuditedSubject(subject));
        if (attributesAffected != null) {
            for (AccessedAttribute attribute : attributesAffected) {
                auditLogEntry.addModifiedValues(attribute.getIdentifier(), String.valueOf(attribute.getOldValue()), String.valueOf(attribute.getNewValue()));
            }
        }
        this.fillCommonAttributesAndLog((AuditLogMessageExtension)auditLogEntry, initiator, error);
    }

    private void fillCommonAttributesAndLog(@Nonnull AuditLogMessageExtension auditLogEntry, @Nonnull AccessRequester initiator, @Nullable Throwable throwable) {
        auditLogEntry.setCaller((String)initiator.getIpAddress().orElse(null), null, (String)initiator.getUserId().orElse(null), null, null, null, (String)initiator.getTenantId().orElse(null));
        auditLogEntry.addCustomAttribute(ATTRIBUTE_CALLER_CHANNEL, (String)initiator.getChannel().orElse(null));
        if (throwable != null) {
            auditLogEntry.addCustomAttribute(ATTRIBUTE_ERROR_MESSAGE, throwable.getMessage());
            auditLogEntry.addCustomAttribute(ATTRIBUTE_STACK_TRACE, Throwables.getStackTraceAsString((Throwable)throwable));
        }
        try {
            auditLogEntry.log(this.getClass());
        }
        catch (AuditLogWriteException e) {
            logger.error("Unable to write audit log entry. Entry contents: [" + auditLogEntry + "]", (Throwable)e);
        }
    }

    private AuditedObject convertAuditedObject(@Nonnull AuditedDataObject sdkObject) {
        AuditedObject converted = this.auditLogExtensionMessageFactory.createAuditedObject();
        converted.setType(sdkObject.getType());
        for (Map.Entry identifier : sdkObject.getAllIdentifiers().entrySet()) {
            converted.addIdentifier((String)identifier.getKey(), (String)identifier.getValue());
        }
        return converted;
    }

    private com.sap.cloud.auditlog.AuditedDataSubject convertAuditedSubject(@Nonnull AuditedDataSubject sdkSubject) {
        com.sap.cloud.auditlog.AuditedDataSubject converted = this.auditLogExtensionMessageFactory.createAuditedDataSubject();
        converted.setType(sdkSubject.getType());
        converted.setRole(sdkSubject.getRole());
        for (Map.Entry identifier : sdkSubject.getAllIdentifiers().entrySet()) {
            converted.addIdentifier((String)identifier.getKey(), (String)identifier.getValue());
        }
        return converted;
    }
}

