/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.cache;

import com.sap.cloud.sdk.cloudplatform.security.user.UserAccessor;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserNotAuthenticatedException;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantNotAvailableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CacheKey {
    @Nullable
    private final String tenantId;
    @Nullable
    private final String userName;
    private final ArrayList<Object> components = new ArrayList();

    @Nonnull
    public Optional<String> getTenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    @Nonnull
    public Optional<String> getUserName() {
        return Optional.ofNullable(this.userName);
    }

    private CacheKey(@Nullable String tenantId, @Nullable String userName) {
        this.tenantId = tenantId;
        this.userName = userName;
    }

    @Nonnull
    public CacheKey append(@Nonnull Iterable<Object> objects) throws IllegalArgumentException {
        for (Object object : objects) {
            if (object == null) {
                throw new IllegalArgumentException("Object must not be null.");
            }
            this.components.add(object);
        }
        return this;
    }

    @Nonnull
    public CacheKey append(Object ... objects) throws IllegalArgumentException {
        this.append(Arrays.asList(objects));
        return this;
    }

    @Nonnull
    public static CacheKey of(@Nullable String tenantId, @Nullable String userName) {
        return new CacheKey(tenantId, userName);
    }

    @Nonnull
    public static CacheKey ofNoIsolation() {
        return CacheKey.of(null, null);
    }

    @Nonnull
    public static CacheKey ofTenantIsolation() throws TenantNotAvailableException, TenantAccessException {
        return CacheKey.of(TenantAccessor.getCurrentTenant().getTenantId(), null);
    }

    @Nonnull
    public static CacheKey ofTenantAndUserIsolation() throws TenantNotAvailableException, TenantAccessException, UserNotAuthenticatedException, UserAccessException {
        return CacheKey.of(TenantAccessor.getCurrentTenant().getTenantId(), UserAccessor.getCurrentUser().getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheKey)) {
            return false;
        }
        CacheKey other = (CacheKey)o;
        Optional<String> this$tenantId = this.getTenantId();
        Optional<String> other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        Optional<String> this$userName = this.getUserName();
        Optional<String> other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !((Object)this$userName).equals(other$userName)) {
            return false;
        }
        ArrayList<Object> this$components = this.getComponents();
        ArrayList<Object> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        Optional<String> $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : ((Object)$userName).hashCode());
        ArrayList<Object> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    public String toString() {
        return "CacheKey(tenantId=" + this.getTenantId() + ", userName=" + this.getUserName() + ", components=" + this.getComponents() + ")";
    }

    public ArrayList<Object> getComponents() {
        return this.components;
    }
}

