/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.cache;

import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAccessor;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserNotAuthenticatedException;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantNotAvailableException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public final class CacheManager {
    private static final Logger logger = CloudLoggerFactory.getLogger(CacheManager.class);
    private static final List<Cache<CacheKey, ?>> cacheList = new ArrayList();

    @Nonnull
    public static ImmutableList<Cache<CacheKey, ?>> getCacheList() {
        return ImmutableList.copyOf(cacheList);
    }

    @Nonnull
    public static synchronized <T> Cache<CacheKey, T> register(@Nonnull Cache<CacheKey, T> cache) {
        cacheList.add(cache);
        return cache;
    }

    public static void cleanUp() {
        for (Cache<CacheKey, ?> cache : cacheList) {
            cache.cleanUp();
        }
        if (logger.isInfoEnabled()) {
            logger.info("Clean up of invalidated caches finished successfully.");
        }
    }

    public static long invalidateAll() {
        long size = 0L;
        for (Cache<CacheKey, ?> cache : cacheList) {
            size += cache.size();
            cache.invalidateAll();
        }
        if (logger.isInfoEnabled()) {
            logger.info("Successfully invalidated " + size + " " + (size == 1L ? "entry" : "entries") + " in " + cacheList.size() + " " + (cacheList.size() == 1 ? "cache" : "caches") + ".");
        }
        return size;
    }

    public static long invalidateTenantCaches() throws TenantNotAvailableException, TenantAccessException {
        return CacheManager.invalidateTenantCaches(TenantAccessor.getCurrentTenant().getTenantId());
    }

    public static long invalidateTenantCaches(String tenantId) {
        long size = 0L;
        for (Cache<CacheKey, ?> cache : cacheList) {
            ArrayList<CacheKey> keysToInvalidate = new ArrayList<CacheKey>();
            for (CacheKey cacheKey : cache.asMap().keySet()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Checking cache invalidation for tenant \"" + tenantId + "\": " + cacheKey + ".");
                }
                if (!tenantId.equals(cacheKey.getTenantId().orElse(null))) continue;
                keysToInvalidate.add(cacheKey);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Invalidating caches of tenant \"" + tenantId + "\": " + keysToInvalidate + ".");
            }
            size += (long)keysToInvalidate.size();
            cache.invalidateAll(keysToInvalidate);
        }
        logger.info("Successfully invalidated caches of tenant \"" + tenantId + "\": " + size + ".");
        return size;
    }

    public static long invalidateUserCaches() throws TenantNotAvailableException, TenantAccessException, UserNotAuthenticatedException, UserAccessException {
        return CacheManager.invalidateUserCaches(TenantAccessor.getCurrentTenant().getTenantId(), UserAccessor.getCurrentUser().getName());
    }

    public static long invalidateUserCaches(String tenantId, String userName) {
        long size = 0L;
        for (Cache<CacheKey, ?> cache : cacheList) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invalidating user cache entries.");
            }
            size += CacheManager.invalidateUserEntries(tenantId, userName, cache);
        }
        logger.info("Successfully invalidated caches of user \"" + userName + "\" within tenant \"" + tenantId + "\": " + size);
        return size;
    }

    public static long invalidateUserEntries(Cache<CacheKey, ?> cache) throws TenantNotAvailableException, TenantAccessException, UserNotAuthenticatedException, UserAccessException {
        return CacheManager.invalidateUserEntries(TenantAccessor.getCurrentTenant().getTenantId(), UserAccessor.getCurrentUser().getName(), cache);
    }

    public static long invalidateUserEntries(String tenantId, String userName, Cache<CacheKey, ?> cache) {
        ArrayList<CacheKey> keysToInvalidate = new ArrayList<CacheKey>();
        for (CacheKey cacheKey : cache.asMap().keySet()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Checking invalidation  for user \"" + userName + "\" within tenant \"" + tenantId + "\": " + cacheKey);
            }
            boolean isEqualTenantId = tenantId.equals(cacheKey.getTenantId().orElse(null));
            boolean isEqualUserName = userName.equals(cacheKey.getUserName().orElse(null));
            if (!isEqualTenantId || !isEqualUserName) continue;
            keysToInvalidate.add(cacheKey);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Invalidating caches of user \"" + userName + "\" within tenant \"" + tenantId + "\": " + keysToInvalidate);
        }
        long size = keysToInvalidate.size();
        cache.invalidateAll(keysToInvalidate);
        return size;
    }
}

