/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.cache;

import com.google.common.cache.Cache;
import com.sap.cloud.sdk.cloudplatform.cache.CacheManager;
import com.sap.cloud.sdk.cloudplatform.cache.CacheMonitorMXBean;
import com.sap.cloud.sdk.cloudplatform.cache.CacheStats;
import com.sap.cloud.sdk.cloudplatform.monitoring.JmxMonitor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.ServletContextEvent;
import javax.servlet.annotation.WebListener;

@WebListener
public class CacheMonitor
extends JmxMonitor
implements CacheMonitorMXBean {
    private static final CacheMonitor instance = new CacheMonitor();

    @Override
    public long invalidateCaches() {
        return CacheManager.invalidateAll();
    }

    @Override
    public long invalidateTenantCaches(String tenantId) {
        return CacheManager.invalidateTenantCaches(tenantId);
    }

    @Override
    public long invalidateUserCaches(String tenantId, String userName) {
        return CacheManager.invalidateUserCaches(tenantId, userName);
    }

    private CacheStats stats() {
        long cacheSize = 0L;
        long hitCount = 0L;
        long missCount = 0L;
        long loadSuccessCount = 0L;
        long loadExceptionCount = 0L;
        long totalLoadTime = 0L;
        long evictionCount = 0L;
        for (Cache cache : CacheManager.getCacheList()) {
            com.google.common.cache.CacheStats stats = cache.stats();
            cacheSize += cache.size();
            hitCount += stats.hitCount();
            missCount += stats.missCount();
            loadSuccessCount += stats.loadSuccessCount();
            loadExceptionCount += stats.loadExceptionCount();
            totalLoadTime += stats.totalLoadTime();
            evictionCount += stats.evictionCount();
        }
        return new CacheStats(cacheSize, hitCount, missCount, loadSuccessCount, loadExceptionCount, totalLoadTime, evictionCount);
    }

    @Override
    public long getCacheSize() {
        return this.stats().getCacheSize();
    }

    @Override
    public long getHitCount() {
        return this.stats().getHitCount();
    }

    @Override
    public long getMissCount() {
        return this.stats().getMissCount();
    }

    @Override
    public long getLoadSuccessCount() {
        return this.stats().getLoadSuccessCount();
    }

    @Override
    public long getLoadExceptionCount() {
        return this.stats().getLoadExceptionCount();
    }

    @Override
    public long getTotalLoadTime() {
        return this.stats().getTotalLoadTime();
    }

    @Override
    public long getEvictionCount() {
        return this.stats().getEvictionCount();
    }

    @Override
    @Nonnull
    public List<CacheStats> getCacheStatsList() {
        ArrayList<CacheStats> result = new ArrayList<CacheStats>();
        for (Cache cache : CacheManager.getCacheList()) {
            com.google.common.cache.CacheStats stats = cache.stats();
            result.add(new CacheStats(cache.size(), stats.hitCount(), stats.missCount(), stats.loadSuccessCount(), stats.loadExceptionCount(), stats.totalLoadTime(), stats.evictionCount()));
        }
        return result;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        instance.registerJmxBean();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        instance.unregisterJmxBean();
    }

    public static CacheMonitor getInstance() {
        return instance;
    }
}

