/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.marmolata.hcp.backend;

import java.lang.reflect.InvocationTargetException;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;

/**
 * This class wraps calls to the user session classes on SAP CP Neo which are required to ensure correct management of
 * user sessions across threads. The full qualified class name of this class must not be modified as it is white-listed
 * in SCP Neo's Tomcat containers to have access to the relevant user session classes.
 */
public class HCPInterop$
{
    private static final Logger logger = CloudLoggerFactory.getLogger(HCPInterop$.class);

    private static final String USER_SESSION_CLASS = "com.sap.security.auth.service.UserSession";
    private static final String USER_SESSION_INITIALIZE = "initialize";
    private static final String USER_SESSION_RESET = "removeInstance";

    private static final String USER_SESSION_ACCESSOR_CLASS = "com.sap.security.um.service.api.UserSessionAccessor";
    private static final String USER_SESSION_ACCESSOR_INITIALIZE = "initializeAccessor";
    private static final String USER_SESSION_ACCESSOR_RESET = "removeSessionAccessor";

    private static final Class<?>[] classArrayRequest = { HttpServletRequest.class };

    private Class<?> classLoadingBridgeClass = null;

    private Class<?> userSessionClass;
    private Class<?> userSessionAccessorClass;

    public HCPInterop$()
    {
        try {
            classLoadingBridgeClass = Class.forName("com.sap.cloud.runtime.impl.bridge.ClassloadingBridge");
        }
        catch( final ClassNotFoundException ignored ) {
            if( logger.isInfoEnabled() ) {
                logger.info(
                    "Failed to initialize ClassloadingBridge. " + "This is expected when using a Java EE runtime.");
            }
        }
    }

    public void initializeUserSession( final HttpServletRequest request )
        throws NoSuchMethodException,
            InvocationTargetException,
            IllegalAccessException,
            ClassNotFoundException
    {
        if( classLoadingBridgeClass == null ) {
            userSessionClass = Class.forName(USER_SESSION_CLASS);
            userSessionClass.getMethod(USER_SESSION_INITIALIZE, HttpServletRequest.class).invoke(null, request);
        } else {
            final ClassLoader classLoader =
                (ClassLoader) classLoadingBridgeClass.getMethod("getImplClassLoader").invoke(null);
            userSessionClass = classLoader.loadClass(USER_SESSION_CLASS);

            final Object[] arrayRequest = { request };
            classLoadingBridgeClass
                .getMethod("invokeMethod", Class.class, Object.class, String.class, Class[].class, Object[].class)
                .invoke(null, userSessionClass, null, USER_SESSION_INITIALIZE, classArrayRequest, arrayRequest);
        }
    }

    public void resetUserSession()
        throws NoSuchMethodException,
            InvocationTargetException,
            IllegalAccessException
    {
        if( classLoadingBridgeClass == null ) {
            userSessionClass.getMethod(USER_SESSION_RESET).invoke(null);
        } else {
            classLoadingBridgeClass
                .getMethod("invokeMethod", Class.class, Object.class, String.class, Class[].class, Object[].class)
                .invoke(null, userSessionClass, null, USER_SESSION_RESET, null, null);
        }
    }

    public void initializeUserSessionAccessor( final HttpServletRequest request )
        throws NoSuchMethodException,
            InvocationTargetException,
            IllegalAccessException,
            ClassNotFoundException
    {
        if( classLoadingBridgeClass == null ) {
            userSessionAccessorClass = Class.forName(USER_SESSION_ACCESSOR_CLASS);
            userSessionAccessorClass
                .getMethod(USER_SESSION_ACCESSOR_INITIALIZE, HttpServletRequest.class)
                .invoke(null, request);
        } else {
            final ClassLoader classLoader =
                (ClassLoader) classLoadingBridgeClass.getMethod("getImplClassLoader").invoke(null);
            userSessionAccessorClass = classLoader.loadClass(USER_SESSION_ACCESSOR_CLASS);

            final Object[] arrayRequest = { request };
            classLoadingBridgeClass
                .getMethod("invokeMethod", Class.class, Object.class, String.class, Class[].class, Object[].class)
                .invoke(
                    null,
                    userSessionAccessorClass,
                    null,
                    USER_SESSION_ACCESSOR_INITIALIZE,
                    classArrayRequest,
                    arrayRequest);
        }
    }

    public void resetUserSessionAccessor()
        throws NoSuchMethodException,
            InvocationTargetException,
            IllegalAccessException
    {
        if( classLoadingBridgeClass == null ) {
            userSessionAccessorClass.getMethod(USER_SESSION_ACCESSOR_RESET).invoke(null);
        } else {
            classLoadingBridgeClass
                .getMethod("invokeMethod", Class.class, Object.class, String.class, Class[].class, Object[].class)
                .invoke(null, userSessionAccessorClass, null, USER_SESSION_ACCESSOR_RESET, null, null);
        }
    }
}
