/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.concurrency;

import com.sap.cloud.account.TenantAlreadySetException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.tenant.ScpNeoTenant;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantNotAvailableException;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ScpNeoTenantCallable<T>
implements Callable<T> {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpNeoTenantCallable.class);
    @Nonnull
    private final ScpNeoTenant tenant;
    @Nonnull
    private final Callable<T> callable;

    private ScpNeoTenant getCurrentTenant() throws TenantNotAvailableException, TenantAccessException {
        Tenant tenant = TenantAccessor.getCurrentTenant();
        if (!(tenant instanceof ScpNeoTenant)) {
            throw new ShouldNotHappenException("The current " + Tenant.class.getSimpleName() + " is not an instance of " + ScpNeoTenant.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:tenant-scp-neo.");
        }
        return (ScpNeoTenant)tenant;
    }

    @Override
    @Nullable
    public T call() throws Exception {
        ScpNeoTenant tenantOfCurrentThread;
        if (logger.isDebugEnabled()) {
            logger.debug("Executing tenant callable in context of thread " + Thread.currentThread().getId() + " and tenant " + this.tenant + ".");
        }
        try {
            tenantOfCurrentThread = this.getCurrentTenant();
        }
        catch (TenantAccessException | TenantNotAvailableException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("No tenant available. Using context of original tenant.", e);
            }
            tenantOfCurrentThread = this.tenant;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing callable in context of tenant " + this.tenant + " with the current thread running in the context of tenant " + tenantOfCurrentThread + ".");
        }
        try {
            return (T)tenantOfCurrentThread.getTenantContext().execute(this.tenant.getTenantId(), this.callable);
        }
        catch (TenantAlreadySetException e) {
            return this.callable.call();
        }
    }

    public ScpNeoTenantCallable(@Nonnull ScpNeoTenant tenant, @Nonnull Callable<T> callable) {
        if (tenant == null) {
            throw new NullPointerException("tenant is marked @NonNull but is null");
        }
        if (callable == null) {
            throw new NullPointerException("callable is marked @NonNull but is null");
        }
        this.tenant = tenant;
        this.callable = callable;
    }

    @Nonnull
    public ScpNeoTenant getTenant() {
        return this.tenant;
    }

    @Nonnull
    public Callable<T> getCallable() {
        return this.callable;
    }

    public String toString() {
        return "ScpNeoTenantCallable(tenant=" + this.getTenant() + ", callable=" + this.getCallable() + ")";
    }
}

