/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoDestinationsRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationOAuthTokenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextExecutor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import com.sap.cloud.sdk.frameworks.hystrix.Command;
import com.sap.cloud.sdk.frameworks.hystrix.HystrixUtil;
import com.sap.core.connectivity.api.authentication.AuthenticationHeader;
import com.sap.core.connectivity.api.authentication.AuthenticationHeaderProvider;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;

class GetAuthHeadersCommand
extends Command<List<Header>> {
    private static final Logger logger = CloudLoggerFactory.getLogger(GetAuthHeadersCommand.class);
    private static final CommandSetterBuilder setterBuilder = new CommandSetterBuilder(GetAuthHeadersCommand.class);
    private final ScpNeoDestination destination;
    @Nullable
    private final URI requestUri;

    GetAuthHeadersCommand(ScpNeoDestination destination, @Nullable URI requestUri) {
        super(setterBuilder.build(destination.getName(), requestUri));
        this.destination = destination;
        this.requestUri = requestUri;
    }

    protected List<Header> run() throws DestinationAccessException {
        DestinationConfiguration destinationConfiguration = this.destination.getDestinationConfiguration();
        if (destinationConfiguration == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping fetching of authentication headers: DestinationConfiguration is null.");
            }
            return Collections.emptyList();
        }
        return this.getAuthenticationHeaders(destinationConfiguration);
    }

    private AuthenticationHeaderProvider getAuthenticationHeaderProvider() throws DestinationAccessException {
        Optional requestContext = RequestContextAccessor.getCurrentRequestContext();
        if (!requestContext.isPresent()) {
            throw new DestinationAccessException("Failed to get " + AuthenticationHeaderProvider.class.getSimpleName() + ": no " + RequestContext.class.getSimpleName() + " available. Have you correctly configured a " + RequestContextServletFilter.class.getSimpleName() + " or have you wrapped your logic in a " + RequestContextExecutor.class.getSimpleName() + " when executing background tasks that are not triggered by a request?");
        }
        try {
            Optional property = ((RequestContext)requestContext.get()).getProperty(ScpNeoDestinationsRequestContextListener.PROPERTY_AUTHENTICATION_HEADER_PROVIDER);
            if (!property.isPresent()) {
                throw new DestinationAccessException("Failed to get " + AuthenticationHeaderProvider.class.getSimpleName() + ": " + RequestContext.class.getSimpleName() + " property \"" + ScpNeoDestinationsRequestContextListener.PROPERTY_AUTHENTICATION_HEADER_PROVIDER + "\" is not present. Please ensure that " + ScpNeoDestinationsRequestContextListener.class.getSimpleName() + " is available on the class path.");
            }
            Exception exception = ((Property)property.get()).getException();
            if (exception != null) {
                throw new DestinationAccessException("Failed to get " + AuthenticationHeaderProvider.class.getSimpleName() + ".", (Throwable)exception);
            }
            return (AuthenticationHeaderProvider)((Property)property.get()).getValue();
        }
        catch (RequestContextPropertyException e) {
            throw new DestinationAccessException("Failed to get " + AuthenticationHeaderProvider.class.getSimpleName() + ": failed to get " + RequestContext.class.getSimpleName() + " property.", (Throwable)e);
        }
    }

    private List<Header> getAuthenticationHeaders(DestinationConfiguration destinationConfiguration) throws DestinationAccessException {
        AuthenticationHeaderProvider authenticationHeaderProvider = this.getAuthenticationHeaderProvider();
        try {
            ArrayList<Header> authenticationHeaders = new ArrayList<Header>();
            switch (this.destination.getAuthenticationType()) {
                case PRINCIPAL_PROPAGATION: {
                    authenticationHeaders.add(this.transformHeader(authenticationHeaderProvider.getPrincipalPropagationHeader()));
                    break;
                }
                case OAUTH2_SAML_BEARER_ASSERTION: {
                    authenticationHeaders.addAll(this.transformHeaders(authenticationHeaderProvider.getOAuth2SAMLBearerAssertionHeaders(destinationConfiguration)));
                    break;
                }
                case APP_TO_APP_SSO: {
                    authenticationHeaders.add(this.transformHeader(authenticationHeaderProvider.getApptoAppSSOHeader((this.requestUri != null ? this.requestUri : this.destination.getUri()).toString(), destinationConfiguration)));
                    break;
                }
                case SAP_ASSERTION_SSO: {
                    authenticationHeaders.add(this.transformHeader(authenticationHeaderProvider.getSAPAssertionHeader(destinationConfiguration)));
                    break;
                }
            }
            return authenticationHeaders;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            if (e.getMessage() != null && e.getMessage().contains("OAuthTokenGenerationException")) {
                throw new DestinationOAuthTokenException(this.destination.getName(), (Throwable)e);
            }
            throw new DestinationAccessException((Throwable)e);
        }
    }

    private Header transformHeader(AuthenticationHeader authenticationHeader) {
        return new Header(authenticationHeader.getName(), authenticationHeader.getValue());
    }

    private Collection<Header> transformHeaders(Iterable<AuthenticationHeader> authenticationHeaders) {
        ArrayList<Header> headers = new ArrayList<Header>();
        for (AuthenticationHeader authenticationHeader : authenticationHeaders) {
            headers.add(this.transformHeader(authenticationHeader));
        }
        return headers;
    }

    private static class CommandSetterBuilder {
        private final Class<? extends Command<?>> commandClass;

        private String getCommandKey(String destinationName, URI requestUri) {
            String commandKey = HystrixUtil.getTenantIsolatedKey(this.commandClass) + HystrixUtil.getDelimiter() + destinationName;
            if (logger.isDebugEnabled()) {
                logger.debug("Constructed command key: \"" + commandKey + "\". Destination: \"" + destinationName + "\", request URI: \"" + requestUri + "\").");
            }
            return commandKey;
        }

        HystrixCommand.Setter build(String destinationName, URI requestUri) {
            String groupKey = HystrixUtil.getGlobalKey(this.commandClass);
            String commandKey = this.getCommandKey(destinationName, requestUri);
            HystrixCommandProperties.Setter commandProperties = HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(6000).withCircuitBreakerEnabled(true).withCircuitBreakerSleepWindowInMilliseconds(6000).withFallbackEnabled(false);
            return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)groupKey)).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey)).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(10).withQueueSizeRejectionThreshold(100).withMaxQueueSize(100)).andCommandPropertiesDefaults(commandProperties);
        }

        public CommandSetterBuilder(Class<? extends Command<?>> commandClass) {
            this.commandClass = commandClass;
        }

        public Class<? extends Command<?>> getCommandClass() {
            return this.commandClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandSetterBuilder)) {
                return false;
            }
            CommandSetterBuilder other = (CommandSetterBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<Command<?>> this$commandClass = this.getCommandClass();
            Class<? extends Command<?>> other$commandClass = other.getCommandClass();
            return !(this$commandClass == null ? other$commandClass != null : !this$commandClass.equals(other$commandClass));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CommandSetterBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<Command<?>> $commandClass = this.getCommandClass();
            result = result * 59 + ($commandClass == null ? 43 : $commandClass.hashCode());
            return result;
        }

        public String toString() {
            return "GetAuthHeadersCommand.CommandSetterBuilder(commandClass=" + this.getCommandClass() + ")";
        }
    }
}

