/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.base.Strings;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpNeoCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.connectivity.AbstractDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.GetAuthHeadersCommand;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.cloudplatform.tenant.ScpNeoTenant;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ScpNeoDestination
extends AbstractDestination {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpNeoDestination.class);
    private static final String SAP_CONNECTIVITY_CONSUMER_ACCOUNT = "SAP-Connectivity-ConsumerAccount";
    private static final String SAP_CONNECTIVITY_SCC_LOCATION_ID_HEADER = "SAP-Connectivity-SCC-Location_ID";
    @Nullable
    private final DestinationConfiguration destinationConfiguration;
    @Nullable
    private final String cloudConnectorLocationId;

    public ScpNeoDestination(@Nullable DestinationConfiguration destinationConfiguration, @Nonnull String name, @Nullable String description, @Nonnull URI uri, @Nonnull AuthenticationType authenticationType, @Nullable BasicCredentials basicCredentials, @Nonnull ProxyType proxyType, @Nullable ProxyConfiguration proxyConfiguration, boolean isTrustingAllCertificates, @Nullable String trustStoreLocation, @Nullable String trustStorePassword, @Nullable String keyStoreLocation, @Nullable String keyStorePassword, @Nullable String cloudConnectorLocationId, @Nonnull Map<String, String> propertiesByName) {
        super(name, description, uri, authenticationType, basicCredentials, proxyType, proxyConfiguration, isTrustingAllCertificates, trustStoreLocation, trustStorePassword, keyStoreLocation, keyStorePassword, propertiesByName);
        this.destinationConfiguration = destinationConfiguration;
        this.cloudConnectorLocationId = cloudConnectorLocationId;
    }

    private ScpNeoDestination() {
        this(null, "", null, URI.create(""), AuthenticationType.NO_AUTHENTICATION, null, ProxyType.INTERNET, null, false, null, null, null, null, null, Collections.emptyMap());
    }

    @Nonnull
    public Optional<String> getCloudConnectorLocationId() {
        return Optional.ofNullable(this.cloudConnectorLocationId);
    }

    @Nonnull
    public Optional<KeyStore> getTrustStore() {
        if (this.destinationConfiguration == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.destinationConfiguration.getTrustStore());
    }

    @Nonnull
    public Optional<KeyStore> getKeyStore() {
        if (this.destinationConfiguration == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.destinationConfiguration.getKeyStore());
    }

    private ProxyConfiguration getOnPremiseProxyConfiguration() throws DestinationAccessException {
        CloudPlatform cloudPlatform = CloudPlatformAccessor.getCloudPlatform();
        if (!(cloudPlatform instanceof ScpNeoCloudPlatform)) {
            throw new ShouldNotHappenException("The current Cloud platform is not an instance of " + ScpNeoCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:core-scp-neo.");
        }
        ScpNeoCloudPlatform scpNeoCloudPlatform = (ScpNeoCloudPlatform)cloudPlatform;
        try {
            String onPremiseProxyHost = scpNeoCloudPlatform.getOnPremiseProxyHost();
            int onPremiseProxyPort = scpNeoCloudPlatform.getOnPremiseProxyPort();
            URI uri = new URI("http://" + onPremiseProxyHost + ":" + onPremiseProxyPort);
            ProxyConfiguration proxyConfiguration = new ProxyConfiguration(uri);
            if (logger.isDebugEnabled()) {
                logger.debug("Using on-premise proxy configuration: " + uri + ".");
            }
            return proxyConfiguration;
        }
        catch (CloudPlatformException e) {
            throw new DestinationAccessException("Failed to get on-premise proxy host or port.", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new DestinationAccessException("Invalid on-premise proxy host or port.", (Throwable)e);
        }
    }

    @Nonnull
    public Optional<ProxyConfiguration> getProxyConfiguration() throws DestinationAccessException {
        if (this.getProxyType() == ProxyType.ON_PREMISE) {
            return Optional.of(this.getOnPremiseProxyConfiguration());
        }
        return Optional.ofNullable(this.proxyConfiguration);
    }

    private Collection<Header> getAuthenticationHeaders(@Nullable URI requestUri) throws DestinationAccessException {
        try {
            return (Collection)new GetAuthHeadersCommand(this, requestUri).execute();
        }
        catch (HystrixBadRequestException | HystrixRuntimeException | IllegalStateException e) {
            throw new DestinationAccessException("Failed to get the request headers for destination \"" + this.getName() + "\" (request URI: " + requestUri + ").", e);
        }
    }

    @Nullable
    private String getCurrentAccountId() {
        Optional currentTenant = TenantAccessor.getCurrentTenantIfAvailable();
        if (!currentTenant.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to determine current account identifier: tenant not available. The connectivity header \"SAP-Connectivity-ConsumerAccount\" will be omitted. On-premise connectivity may not work in consumer accounts.");
            }
            return null;
        }
        Tenant tenant = (Tenant)currentTenant.get();
        if (!(tenant instanceof ScpNeoTenant)) {
            throw new ShouldNotHappenException("The current tenant is not an instance of " + ScpNeoTenant.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:tenant-scp-neo.");
        }
        return ((ScpNeoTenant)tenant).getTenantContext().getTenant().getAccount().getId();
    }

    private Collection<Header> getOnPremiseProxyHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        String currentAccountId = this.getCurrentAccountId();
        if (!Strings.isNullOrEmpty((String)currentAccountId)) {
            headers.add(new Header(SAP_CONNECTIVITY_CONSUMER_ACCOUNT, currentAccountId));
        }
        if (!Strings.isNullOrEmpty((String)this.cloudConnectorLocationId)) {
            headers.add(new Header(SAP_CONNECTIVITY_SCC_LOCATION_ID_HEADER, this.cloudConnectorLocationId));
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully added SAP-Connectivity-SCC-Location_ID header with location identifier \"" + this.cloudConnectorLocationId + "\".");
            }
        }
        return headers;
    }

    @Nonnull
    public List<Header> getHeaders(@Nullable URI requestUri) throws DestinationAccessException {
        List headers = super.getHeaders(requestUri);
        headers.addAll(this.getAuthenticationHeaders(requestUri));
        if (ProxyType.ON_PREMISE == this.getProxyType()) {
            headers.addAll(this.getOnPremiseProxyHeaders());
        }
        return headers;
    }

    @Nullable
    public DestinationConfiguration getDestinationConfiguration() {
        return this.destinationConfiguration;
    }
}

