/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.collect.Sets;
import com.sap.cloud.account.TenantContext;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpNeoCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.connectivity.AbstractDestinationFacade;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationRetrievalStrategy;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.RfcDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoDestinationFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoDestinationParser;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoDestinationsRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoGenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoRfcDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextExecutor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import com.sap.cloud.sdk.cloudplatform.tenant.ScpNeoTenant;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.core.connectivity.api.configuration.ConnectivityConfiguration;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class ScpNeoDestinationFacade
extends AbstractDestinationFacade {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpNeoDestinationFacade.class);
    private final Set<String> destinationNames = Sets.newConcurrentHashSet();

    private ConnectivityConfiguration getConnectivityConfiguration() throws DestinationAccessException {
        Optional requestContext = RequestContextAccessor.getCurrentRequestContext();
        if (!requestContext.isPresent()) {
            throw new DestinationAccessException("Failed to get " + ConnectivityConfiguration.class.getSimpleName() + ": no " + RequestContext.class.getSimpleName() + " available. Have you correctly configured a " + RequestContextServletFilter.class.getSimpleName() + " or have you wrapped your logic in a " + RequestContextExecutor.class.getSimpleName() + " when executing background tasks that are not triggered by a request?");
        }
        try {
            Optional property = ((RequestContext)requestContext.get()).getProperty(ScpNeoDestinationsRequestContextListener.PROPERTY_CONNECTIVITY_CONFIGURATION);
            if (!property.isPresent()) {
                throw new DestinationAccessException("Failed to get " + ConnectivityConfiguration.class.getSimpleName() + ": " + RequestContext.class.getSimpleName() + " property \"" + ScpNeoDestinationsRequestContextListener.PROPERTY_CONNECTIVITY_CONFIGURATION + "\" is not present. Please ensure that " + ScpNeoDestinationsRequestContextListener.class.getSimpleName() + " is available on the class path.");
            }
            Exception exception = ((Property)property.get()).getException();
            if (exception != null) {
                throw new DestinationAccessException("Failed to get " + ConnectivityConfiguration.class.getSimpleName() + ".", (Throwable)exception);
            }
            return (ConnectivityConfiguration)((Property)property.get()).getValue();
        }
        catch (RequestContextPropertyException e) {
            throw new DestinationAccessException("Failed to get " + ConnectivityConfiguration.class.getSimpleName() + ": failed to get " + RequestContext.class.getSimpleName() + " property.", (Throwable)e);
        }
    }

    private DestinationConfiguration getDestinationConfiguration(String destinationName) throws DestinationAccessException, DestinationNotFoundException {
        ConnectivityConfiguration connectivityConfiguration = this.getConnectivityConfiguration();
        try {
            DestinationRetrievalStrategy strategy = DestinationAccessor.getRetrievalStrategy((String)destinationName);
            DestinationConfiguration destinationConfiguration = null;
            if (strategy.equals((Object)DestinationRetrievalStrategy.PLATFORM_DEFAULT)) {
                destinationConfiguration = connectivityConfiguration.getConfiguration(destinationName);
            } else {
                if (strategy.equals((Object)DestinationRetrievalStrategy.ALWAYS_SUBSCRIBER) || strategy.equals((Object)DestinationRetrievalStrategy.SUBSCRIBER_THEN_PROVIDER)) {
                    destinationConfiguration = connectivityConfiguration.getConfiguration(this.getCurrentAccountId(), destinationName);
                }
                if (strategy.equals((Object)DestinationRetrievalStrategy.ALWAYS_PROVIDER) || destinationConfiguration == null && strategy.equals((Object)DestinationRetrievalStrategy.SUBSCRIBER_THEN_PROVIDER)) {
                    destinationConfiguration = connectivityConfiguration.getConfiguration(this.getProviderAccountId(), destinationName);
                }
            }
            if (destinationConfiguration == null) {
                throw new DestinationNotFoundException(destinationName);
            }
            return destinationConfiguration;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new DestinationAccessException("Failed to access configuration for destination \"" + destinationName + "\".", (Throwable)e);
        }
    }

    @Nonnull
    public Class<? extends GenericDestination> getGenericDestinationClass() {
        return ScpNeoGenericDestination.class;
    }

    @Nonnull
    public Class<? extends Destination> getDestinationClass() {
        return ScpNeoDestination.class;
    }

    @Nonnull
    public Class<? extends RfcDestination> getRfcDestinationClass() {
        return ScpNeoRfcDestination.class;
    }

    public void declareDestinations(@Nonnull Collection<String> destinationNames) {
        this.destinationNames.addAll(destinationNames);
    }

    @Nonnull
    public GenericDestination getGenericDestination(@Nonnull String destinationName) throws DestinationNotFoundException, DestinationAccessException {
        Map destinationsFromEnvironmentVariable = this.getDestinationsFromEnvironmentVariable();
        if (destinationsFromEnvironmentVariable != null) {
            return super.getGenericDestination(destinationName);
        }
        DestinationConfiguration destinationConfiguration = this.getDestinationConfiguration(destinationName);
        ScpNeoDestinationParser destinationParser = new ScpNeoDestinationParser(destinationConfiguration);
        return new ScpNeoDestinationFactory(destinationConfiguration).create(destinationParser);
    }

    @Nonnull
    public Map<String, GenericDestination> getGenericDestinationsByName() throws DestinationAccessException {
        if (this.getDestinationsFromEnvironmentVariable() != null) {
            return this.getDestinationsFromEnvironmentVariable(new ScpNeoDestinationFactory());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Resolving destinations by names: " + this.destinationNames + ".");
        }
        HashMap<String, GenericDestination> result = new HashMap<String, GenericDestination>();
        for (String destinationName : this.destinationNames) {
            DestinationConfiguration destinationConfiguration = this.getDestinationConfiguration(destinationName);
            try {
                ScpNeoDestinationParser destinationParser = new ScpNeoDestinationParser(destinationConfiguration);
                GenericDestination destination = new ScpNeoDestinationFactory(destinationConfiguration).create(destinationParser);
                result.put(destinationName, destination);
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("Successfully added %s destination \"%s\" to destination list.", destination.getDestinationType().toString(), destination.getName()));
            }
            catch (DestinationNotFoundException e) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Failed to add destination \"" + destinationName + "\" to the result of getDestinationsByName(): destination not found. This indicates a missing or incorrect destination configuration on Cloud platform side. Correct the configuration of this destination or remove its declaration if obsolete.", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Resolved %d destinations.", result.size()));
        }
        return result;
    }

    @Nonnull
    private String getCurrentAccountId() {
        Tenant tenant = TenantAccessor.getCurrentTenant();
        if (tenant instanceof ScpNeoTenant) {
            TenantContext tenantContext = ((ScpNeoTenant)tenant).getTenantContext();
            return tenantContext.getTenant().getAccount().getId();
        }
        throw new CloudPlatformException("The current tenant is not an instance of " + ScpNeoTenant.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:tenant-scp-neo.");
    }

    @Nonnull
    private String getProviderAccountId() {
        CloudPlatform platform = CloudPlatformAccessor.getCloudPlatform();
        if (platform instanceof ScpNeoCloudPlatform) {
            return ((ScpNeoCloudPlatform)platform).getProviderAccountId();
        }
        throw new CloudPlatformException("The current Cloud platform is not an instance of " + ScpNeoCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:core-scp-neo.");
    }
}

