/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.AbstractDestinationParser;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoDestinationParser;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoGenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpNeoRfcDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import java.util.Map;
import javax.annotation.Nullable;

class ScpNeoDestinationFactory
implements DestinationFactory {
    @Nullable
    private final DestinationConfiguration destinationConfiguration;

    ScpNeoDestinationFactory() {
        this(null);
    }

    ScpNeoDestinationFactory(@Nullable DestinationConfiguration destinationConfiguration) {
        this.destinationConfiguration = destinationConfiguration;
    }

    public GenericDestination create(AbstractDestinationParser destinationParser) throws DestinationAccessException {
        DestinationType destinationType = destinationParser.getType();
        String name = destinationParser.getName();
        String description = destinationParser.getDescription();
        Map properties = destinationParser.getProperties();
        switch (destinationType) {
            case HTTP: {
                return new ScpNeoDestination(this.destinationConfiguration, name, description, destinationParser.getUri(), destinationParser.getAuthenticationType(), destinationParser.getBasicCredentials(), destinationParser.getProxyType(), destinationParser.getProxyConfiguration(), destinationParser.getTrustAll(), destinationParser.getTrustStoreLocation(), destinationParser.getTrustStorePassword(), destinationParser.getKeyStoreLocation(), destinationParser.getKeyStorePassword(), destinationParser instanceof ScpNeoDestinationParser ? ((ScpNeoDestinationParser)destinationParser).getCloudConnectorLocationId() : null, properties);
            }
            case RFC: {
                return new ScpNeoRfcDestination(name, description, properties);
            }
        }
        return new ScpNeoGenericDestination(destinationType, name, description, properties);
    }
}

