/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.AbstractDestinationParser;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;

class ScpNeoDestinationParser
extends AbstractDestinationParser {
    private static final Logger logger = CloudLoggerFactory.getSanitizedLogger(ScpNeoDestinationParser.class);
    private static final String PROPERTY_CLOUD_CONNECTOR_LOCATION_ID = "CloudConnectorLocationId";
    private static final int DEFAULT_HTTPS_PORT = 443;
    private final DestinationConfiguration destinationConfiguration;

    @Nullable
    URI getUri() throws DestinationAccessException {
        URI uri = super.getUri();
        if (uri != null && this.getProxyType() == ProxyType.ON_PREMISE && "https".equals(uri.getScheme())) {
            if (logger.isWarnEnabled()) {
                logger.warn("Rewriting on-premise destination \"" + this.getName() + "\" with URI scheme \"https\" to use \"http\": " + uri + ". To resolve this warning, make sure to use \"http\" for on-premise destinations.");
            }
            int port = uri.getPort() < 0 ? 443 : uri.getPort();
            try {
                return new URI("http", uri.getUserInfo(), uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new DestinationAccessException("Invalid destination URI.", (Throwable)e);
            }
        }
        return uri;
    }

    @Nullable
    String getCloudConnectorLocationId() {
        return this.getPropertyIfExists(new String[]{PROPERTY_CLOUD_CONNECTOR_LOCATION_ID});
    }

    Map<String, String> getProperties() throws DestinationAccessException {
        return this.destinationConfiguration.getAllProperties();
    }

    ScpNeoDestinationParser(DestinationConfiguration destinationConfiguration) {
        this.destinationConfiguration = destinationConfiguration;
    }

    DestinationConfiguration getDestinationConfiguration() {
        return this.destinationConfiguration;
    }
}

