/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.AbstractGenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.security.BasicAuthHeaderEncoder;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractDestination
extends AbstractGenericDestination
implements Destination {
    private static final String BASIC_PREFIX = "Basic ";
    @Nonnull
    protected final URI uri;
    @Nonnull
    protected final AuthenticationType authenticationType;
    @Nullable
    protected final BasicCredentials basicCredentials;
    @Nonnull
    protected final ProxyType proxyType;
    @Nullable
    protected final ProxyConfiguration proxyConfiguration;
    protected final boolean isTrustingAllCertificates;
    @Nullable
    protected final String trustStoreLocation;
    @Nullable
    protected final String trustStorePassword;
    @Nullable
    protected final String keyStoreLocation;
    @Nullable
    protected final String keyStorePassword;

    public AbstractDestination(@Nonnull String name, @Nullable String description, @Nonnull URI uri, @Nonnull AuthenticationType authenticationType, @Nullable BasicCredentials basicCredentials, @Nonnull ProxyType proxyType, @Nullable ProxyConfiguration proxyConfiguration, boolean isTrustingAllCertificates, @Nullable String trustStoreLocation, @Nullable String trustStorePassword, @Nullable String keyStoreLocation, @Nullable String keyStorePassword, @Nonnull Map<String, String> propertiesByName) {
        super(DestinationType.HTTP, name, description, propertiesByName);
        this.uri = uri;
        this.authenticationType = authenticationType;
        this.basicCredentials = basicCredentials;
        this.proxyType = proxyType;
        this.proxyConfiguration = proxyConfiguration;
        this.isTrustingAllCertificates = isTrustingAllCertificates;
        this.trustStoreLocation = trustStoreLocation;
        this.trustStorePassword = trustStorePassword;
        this.keyStoreLocation = keyStoreLocation;
        this.keyStorePassword = keyStorePassword;
    }

    @Nonnull
    public Optional<BasicCredentials> getBasicCredentials() {
        return Optional.ofNullable(this.basicCredentials);
    }

    @Override
    @Nonnull
    public Optional<ProxyConfiguration> getProxyConfiguration() {
        return Optional.ofNullable(this.proxyConfiguration);
    }

    @Override
    @Nonnull
    public Optional<String> getTrustStorePassword() {
        return Optional.ofNullable(this.trustStorePassword);
    }

    @Override
    @Nonnull
    public Optional<String> getKeyStorePassword() {
        return Optional.ofNullable(this.keyStorePassword);
    }

    @Override
    @Nonnull
    public List<Header> getHeaders(@Nullable URI requestUri) throws DestinationAccessException {
        ArrayList<Header> headers = new ArrayList<Header>(this.getDefaultHeaders());
        if (this.getAuthenticationType() == AuthenticationType.BASIC_AUTHENTICATION) {
            if (this.basicCredentials != null) {
                headers.add(new Header("Authorization", BASIC_PREFIX + BasicAuthHeaderEncoder.encodeUserPasswordBase64((BasicCredentials)this.basicCredentials)));
            } else {
                throw new DestinationAccessException("Failed to add \"Authorization\" header for Basic authentication: no credentials available.");
            }
        }
        return headers;
    }

    @Nonnull
    protected List<Header> getDefaultHeaders() {
        ArrayList<Header> defaultHeaders = new ArrayList<Header>();
        Collection defaultProvider = FacadeLocator.getFacades(DestinationHeaderProvider.class);
        for (DestinationHeaderProvider provider : defaultProvider) {
            List<Header> headers = provider.getHeaders(this);
            defaultHeaders.addAll(headers);
        }
        return defaultHeaders;
    }

    @Override
    @Nonnull
    public URI getUri() {
        return this.uri;
    }

    @Override
    @Nonnull
    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    @Override
    @Nonnull
    public ProxyType getProxyType() {
        return this.proxyType;
    }

    @Override
    public boolean isTrustingAllCertificates() {
        return this.isTrustingAllCertificates;
    }
}

