/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;

abstract class AbstractDestinationParser {
    private static final Logger logger = CloudLoggerFactory.getLogger(AbstractDestinationParser.class);
    static final String PROPERTY_TYPE = "Type";
    static final String PROPERTY_NAME = "Name";
    static final String PROPERTY_DESCRIPTION = "Description";
    static final String PROPERTY_URI = "URL";
    static final String PROPERTY_AUTHENTICATION = "Authentication";
    static final String PROPERTY_PROXY_TYPE = "ProxyType";
    static final String PROPERTY_USERNAME = "User";
    static final String PROPERTY_PASSWORD = "Password";
    static final String PROPERTY_TRUST_STORE_LOCATION = "TrustStoreLocation";
    static final String PROPERTY_TRUST_STORE_PASSWORD = "TrustStorePassword";
    static final String PROPERTY_KEY_STORE_LOCATION = "KeyStoreLocation";
    static final String PROPERTY_KEY_STORE_PASSWORD = "KeyStorePassword";
    static final Set<String> standardPropertyKeys = Sets.newHashSet((Object[])new String[]{"Type", "Name", "URL", "Description", "Authentication", "ProxyType", "User", "Password", "TrustStoreLocation", "TrustStorePassword", "KeyStoreLocation", "KeyStorePassword"});
    static final String PROPERTY_PROXY_URI = "proxy";
    static final String PROPERTY_PROXY_HOST = "proxyHost";
    static final String PROPERTY_PROXY_PORT = "proxyPort";
    static final String PROPERTY_TRUST_ALL = "TrustAll";

    @Nullable
    protected String getPropertyIfExists(String ... propertyAliases) {
        Map<String, String> properties = this.getProperties();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            for (String propertyAlias : propertyAliases) {
                if (!propertyAlias.equalsIgnoreCase(key)) continue;
                return value;
            }
        }
        return null;
    }

    protected String getPropertyOrThrowException(String propertyAlias) throws DestinationAccessException {
        String property = this.getPropertyIfExists(propertyAlias);
        if (property == null) {
            throw new DestinationAccessException("No valid JSON primitive defined for property \"" + propertyAlias + "\".");
        }
        return property;
    }

    DestinationType getType() throws DestinationAccessException {
        String destinationType = this.getPropertyIfExists(PROPERTY_TYPE);
        if (Strings.isNullOrEmpty((String)destinationType)) {
            return DestinationType.HTTP;
        }
        try {
            return DestinationType.ofIdentifier(destinationType);
        }
        catch (IllegalArgumentException e) {
            throw new DestinationAccessException("Unsupported destination type.", e);
        }
    }

    String getName() throws DestinationAccessException {
        return this.getPropertyOrThrowException(PROPERTY_NAME);
    }

    @Nullable
    String getDescription() {
        return this.getPropertyIfExists(PROPERTY_DESCRIPTION);
    }

    @Nullable
    URI getUri() throws DestinationAccessException {
        String uriAsString = this.getPropertyIfExists(PROPERTY_URI, "uri");
        try {
            return uriAsString == null ? null : new URI(uriAsString);
        }
        catch (URISyntaxException e) {
            throw new DestinationAccessException("Invalid destination URI.", e);
        }
    }

    AuthenticationType getAuthenticationType() {
        String authTypeAsString = this.getPropertyIfExists(PROPERTY_AUTHENTICATION);
        if (Strings.isNullOrEmpty((String)authTypeAsString)) {
            AuthenticationType fallback = this.getBasicCredentials() != null ? AuthenticationType.BASIC_AUTHENTICATION : AuthenticationType.NO_AUTHENTICATION;
            if (logger.isDebugEnabled()) {
                logger.debug("No valid JSON primitive \"Authentication\" defined. Falling back to " + (Object)((Object)fallback) + ".");
            }
            return fallback;
        }
        return AuthenticationType.ofIdentifierOrDefault(authTypeAsString, AuthenticationType.NO_AUTHENTICATION);
    }

    @Nullable
    BasicCredentials getBasicCredentials() {
        BasicCredentials credentials;
        String username = this.getPropertyIfExists(PROPERTY_USERNAME, "username");
        String password = this.getPropertyIfExists(PROPERTY_PASSWORD);
        if (username != null && password != null) {
            credentials = new BasicCredentials(username, password);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("No valid JSON primitives \"User\" and \"Password\" defined. Continuing without basic credentials.");
            }
            credentials = null;
        }
        return credentials;
    }

    ProxyType getProxyType() {
        String proxyTypeAsString = this.getPropertyIfExists(PROPERTY_PROXY_TYPE);
        if (proxyTypeAsString != null) {
            if (proxyTypeAsString.equalsIgnoreCase("onpremise") || proxyTypeAsString.equalsIgnoreCase("on-premise") || proxyTypeAsString.equalsIgnoreCase("on_premise")) {
                return ProxyType.ON_PREMISE;
            }
            return ProxyType.INTERNET;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("No valid JSON primitive \"ProxyType\" defined. Falling back to " + (Object)((Object)ProxyType.INTERNET) + ".");
        }
        ProxyType proxyType = ProxyType.INTERNET;
        return proxyType;
    }

    @Nullable
    ProxyConfiguration getProxyConfiguration() throws DestinationAccessException {
        Integer proxyPort;
        if (this.getProxyType() != ProxyType.INTERNET) {
            return null;
        }
        String proxyUri = this.getPropertyIfExists(PROPERTY_PROXY_URI);
        String proxyHost = this.getPropertyIfExists(PROPERTY_PROXY_HOST);
        String portAsString = this.getPropertyIfExists(PROPERTY_PROXY_PORT);
        try {
            proxyPort = portAsString == null ? null : Integer.valueOf(portAsString);
        }
        catch (NumberFormatException e) {
            throw new DestinationAccessException("Invalid proxy port.", e);
        }
        if (proxyUri != null) {
            try {
                String proxyUriWithScheme = this.addHttpSchemeIfNoSchemeIsPresent(proxyUri);
                return new ProxyConfiguration(new URI(proxyUriWithScheme));
            }
            catch (URISyntaxException e) {
                throw new DestinationAccessException("Invalid proxy URI.", e);
            }
        }
        if (proxyHost != null && proxyPort != null) {
            try {
                return new ProxyConfiguration(new URI("http", null, proxyHost, proxyPort, null, null, null));
            }
            catch (URISyntaxException e) {
                throw new DestinationAccessException("Invalid proxy host or port.", e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("No proxy URI or host and port specified. Continuing without proxy configuration.");
        }
        return null;
    }

    private String addHttpSchemeIfNoSchemeIsPresent(String proxyUri) {
        String proxyUriWithScheme;
        if (proxyUri.contains("://")) {
            proxyUriWithScheme = proxyUri;
        } else {
            proxyUriWithScheme = "http://" + proxyUri;
            if (logger.isInfoEnabled()) {
                logger.info("Proxy URI " + proxyUri + " lacks required URI scheme. Scheme \"http\" was added as default value.");
            }
        }
        return proxyUriWithScheme;
    }

    boolean getTrustAll() {
        return Boolean.valueOf(this.getPropertyIfExists(PROPERTY_TRUST_ALL));
    }

    @Nullable
    String getTrustStoreLocation() {
        return this.getPropertyIfExists(PROPERTY_TRUST_STORE_LOCATION);
    }

    @Nullable
    String getTrustStorePassword() {
        return this.getPropertyIfExists(PROPERTY_TRUST_STORE_PASSWORD);
    }

    @Nullable
    String getKeyStoreLocation() {
        return this.getPropertyIfExists(PROPERTY_KEY_STORE_LOCATION);
    }

    @Nullable
    String getKeyStorePassword() {
        return this.getPropertyIfExists(PROPERTY_KEY_STORE_PASSWORD);
    }

    abstract Map<String, String> getProperties() throws DestinationAccessException;
}

