/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractGenericDestination
implements GenericDestination {
    @Nonnull
    private final DestinationType destinationType;
    @Nonnull
    private final String name;
    @Nullable
    private final String description;
    @Nonnull
    private final ImmutableMap<String, String> propertiesByName;

    @Override
    @Nonnull
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public AbstractGenericDestination(@Nonnull DestinationType destinationType, @Nonnull String name, @Nullable String description, @Nonnull Map<String, String> propertiesByName) {
        this.destinationType = destinationType;
        this.name = name;
        this.description = description;
        this.propertiesByName = ImmutableMap.copyOf(propertiesByName);
    }

    @Override
    @Nonnull
    public Map<String, String> getPropertiesByName() {
        return this.propertiesByName;
    }

    @Nonnull
    public String toString() {
        HashMap nonSensitiveProperties = Maps.newHashMap(this.getPropertiesByName());
        for (Map.Entry entry : nonSensitiveProperties.entrySet()) {
            if (!((String)entry.getKey()).toLowerCase(Locale.ENGLISH).contains("password")) continue;
            entry.setValue("(hidden)");
        }
        return this.getClass().getSimpleName() + "(destinationType=" + (Object)((Object)this.destinationType) + ", name=" + this.name + ", description=" + this.description + ", propertiesByName=" + nonSensitiveProperties + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractGenericDestination)) {
            return false;
        }
        AbstractGenericDestination other = (AbstractGenericDestination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$propertiesByName = this.getPropertiesByName();
        Map<String, String> other$propertiesByName = other.getPropertiesByName();
        return !(this$propertiesByName == null ? other$propertiesByName != null : !((Object)this$propertiesByName).equals(other$propertiesByName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractGenericDestination;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $propertiesByName = this.getPropertiesByName();
        result = result * 59 + ($propertiesByName == null ? 43 : ((Object)$propertiesByName).hashCode());
        return result;
    }

    @Override
    @Nonnull
    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }
}

