/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientCache;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.RequestScopedHttpClientCache;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import javax.annotation.Nonnull;
import org.apache.http.client.HttpClient;

public final class HttpClientAccessor {
    @Nonnull
    private static HttpClientFactory httpClientProvider = new DefaultHttpClientFactory();
    @Nonnull
    private static HttpClientCache httpClientCache = new RequestScopedHttpClientCache();

    @Nonnull
    public static HttpClient getHttpClient() throws HttpClientInstantiationException {
        return httpClientCache.getHttpClient(httpClientProvider);
    }

    @Nonnull
    public static HttpClient getHttpClient(@Nonnull String destinationName) throws DestinationNotFoundException, DestinationAccessException, HttpClientInstantiationException {
        return HttpClientAccessor.getHttpClient(DestinationAccessor.getDestination(destinationName));
    }

    @Nonnull
    public static HttpClient getHttpClient(@Nonnull Destination destination) throws DestinationAccessException, HttpClientInstantiationException {
        return httpClientCache.getHttpClient(destination, httpClientProvider);
    }

    @Nonnull
    public static HttpClientFactory getHttpClientProvider() {
        return httpClientProvider;
    }

    public static void setHttpClientProvider(@Nonnull HttpClientFactory httpClientProvider) {
        if (httpClientProvider == null) {
            throw new NullPointerException("httpClientProvider is marked @NonNull but is null");
        }
        HttpClientAccessor.httpClientProvider = httpClientProvider;
    }

    @Nonnull
    public static HttpClientCache getHttpClientCache() {
        return httpClientCache;
    }

    public static void setHttpClientCache(@Nonnull HttpClientCache httpClientCache) {
        if (httpClientCache == null) {
            throw new NullPointerException("httpClientCache is marked @NonNull but is null");
        }
        HttpClientAccessor.httpClientCache = httpClientCache;
    }
}

