/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientWrapper;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;

class HttpClientBuilder {
    private static final Logger logger = CloudLoggerFactory.getLogger(HttpClientBuilder.class);
    private static final File JDK_TRUST_STORE_FILE = new File(System.getProperty("java.home"), "/lib/security/cacerts");
    private static final int DEFAULT_TIMEOUT_MINUTES = 2;
    private static final int MAX_TOTAL_CONNECTIONS = 200;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 100;
    private static final String UNDEFINED_PROXY_MAY_BE_EXPECTED_MESSAGE = "This behavior may be expected in tests and some local runtimes.";

    HttpClientBuilder() {
    }

    @Nonnull
    HttpClient build() throws HttpClientInstantiationException {
        org.apache.http.impl.client.HttpClientBuilder clientBuilder = HttpClients.custom();
        this.setConnectionManager(clientBuilder, null);
        this.setTimeout(clientBuilder);
        return clientBuilder.build();
    }

    @Nonnull
    HttpClient build(@Nonnull Destination destination) throws DestinationAccessException, HttpClientInstantiationException {
        DestinationType destinationType = destination.getDestinationType();
        if (DestinationType.HTTP != destinationType) {
            throw new HttpClientInstantiationException(HttpClient.class.getSimpleName() + " creation is only supported for " + DestinationType.class.getSimpleName() + " " + (Object)((Object)DestinationType.HTTP) + ". Actual type: " + (Object)((Object)destinationType) + ".");
        }
        org.apache.http.impl.client.HttpClientBuilder clientBuilder = HttpClients.custom();
        this.setConnectionManager(clientBuilder, destination);
        this.setTimeout(clientBuilder);
        this.setProxy(destination, clientBuilder);
        return new HttpClientWrapper((HttpClient)clientBuilder.build(), destination);
    }

    private void setConnectionManager(org.apache.http.impl.client.HttpClientBuilder clientBuilder, Destination destination) {
        PoolingHttpClientConnectionManager connectionManager;
        if (destination != null && "https".equalsIgnoreCase(destination.getUri().getScheme())) {
            try {
                TrustManager[] trustManagers = this.getTrustManagers(destination);
                KeyManager[] keyManagers = this.getKeyManagers(destination);
                String tlsVersion = destination.getPropertiesByName().get("TLSVersion");
                SSLContext sslContext = SSLContext.getInstance(tlsVersion != null ? tlsVersion : "TLSv1.2");
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
                SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
                clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
                RegistryBuilder registryBuilder = RegistryBuilder.create().register("https", (Object)sslConnectionFactory);
                if (destination.getProxyConfiguration().isPresent()) {
                    registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
                }
                connectionManager = new PoolingHttpClientConnectionManager(registryBuilder.build());
            }
            catch (IOException | GeneralSecurityException e) {
                throw new HttpClientInstantiationException(e);
            }
        } else {
            connectionManager = new PoolingHttpClientConnectionManager();
        }
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(100);
        clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
    }

    private void setTimeout(org.apache.http.impl.client.HttpClientBuilder clientBuilder) {
        int milliseconds = (int)TimeUnit.MINUTES.toMillis(2L);
        try {
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(milliseconds).build();
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(milliseconds).build();
            clientBuilder.setDefaultSocketConfig(socketConfig);
            clientBuilder.setDefaultRequestConfig(requestConfig);
        }
        catch (IllegalArgumentException e) {
            logger.error("Failed to set timeout on " + HttpClient.class.getSimpleName() + ". This is expected within unit tests.");
        }
    }

    private void setProxy(Destination destination, org.apache.http.impl.client.HttpClientBuilder clientBuilder) {
        ProxyConfiguration proxyConfiguration;
        try {
            proxyConfiguration = destination.getProxyConfiguration().orElse(null);
        }
        catch (DestinationAccessException e) {
            logger.error("Failed to set proxy: failed to retrieve proxy configuration.", (Throwable)e);
            return;
        }
        if (proxyConfiguration != null) {
            URI uri = proxyConfiguration.getUri();
            if (uri == null) {
                logger.error("Failed to set proxy: undefined URI in proxy configuration. This behavior may be expected in tests and some local runtimes.");
                return;
            }
            String host = uri.getHost();
            if (host == null) {
                logger.error("Failed to set proxy: undefined host in URI of proxy configuration. This behavior may be expected in tests and some local runtimes.");
                return;
            }
            int port = uri.getPort();
            if (port < 0) {
                logger.error("Failed to set proxy: undefined port in URI of proxy configuration. This behavior may be expected in tests and some local runtimes.");
                return;
            }
            com.sap.cloud.sdk.cloudplatform.security.Credentials credentials = proxyConfiguration.getCredentials().orElse(null);
            if (credentials instanceof BasicCredentials) {
                BasicCredentials basicCredentials = (BasicCredentials)credentials;
                SystemDefaultCredentialsProvider credentialsProvider = new SystemDefaultCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(basicCredentials.getUsername(), basicCredentials.getPassword()));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            clientBuilder.setDefaultRequestConfig(RequestConfig.custom().setProxy(new HttpHost(host, port, uri.getScheme())).build());
        }
    }

    private TrustManager[] getTrustManagers(Destination destination) throws GeneralSecurityException, IOException {
        ArrayList<TrustManager> trustManagers = new ArrayList<TrustManager>();
        if (destination.isTrustingAllCertificates()) {
            trustManagers.add(new TrustAllTrustManager());
        } else {
            TrustManager destinationTrustManager;
            TrustManager defaultTrustManager = this.createTrustManager(this.getJdkTrustStore());
            if (defaultTrustManager != null) {
                trustManagers.add(defaultTrustManager);
            }
            if ((destinationTrustManager = this.createTrustManager(destination.getTrustStore().orElse(null))) != null) {
                trustManagers.add(destinationTrustManager);
            }
        }
        return trustManagers.toArray(new TrustManager[0]);
    }

    private TrustManager createTrustManager(@Nullable KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        if (keyStore == null) {
            return null;
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore);
        TrustManager[] trustManagers = factory.getTrustManagers();
        if (trustManagers != null && trustManagers.length > 0) {
            return trustManagers[0];
        }
        return null;
    }

    private KeyStore getJdkTrustStore() throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File canonicalFile = JDK_TRUST_STORE_FILE.getCanonicalFile();
        try (FileInputStream is = new FileInputStream(canonicalFile);){
            keyStore.load(is, null);
        }
        return keyStore;
    }

    private KeyManager[] getKeyManagers(Destination destination) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyStore keyStore = destination.getKeyStore().orElse(null);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        String keyStorePassword = destination.getKeyStorePassword().orElse("");
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        return keyManagerFactory.getKeyManagers();
    }

    private static class TrustAllTrustManager
    implements X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

