/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.cache.Cache;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.http.client.HttpClient;

public abstract class HttpClientCache {
    @Nonnull
    protected HttpClient getHttpClient(@Nonnull Destination destination, @Nonnull HttpClientFactory httpClientProvider) throws HttpClientInstantiationException {
        Optional<Cache<CacheKey, HttpClient>> cache = this.getCache();
        CacheKey key = this.getCacheKey(destination);
        if (cache.isPresent()) {
            Cache<CacheKey, HttpClient> actualCache = cache.get();
            try {
                return (HttpClient)actualCache.get((Object)key, () -> httpClientProvider.createHttpClient(destination));
            }
            catch (ExecutionException e) {
                throw new HttpClientInstantiationException(e);
            }
        }
        return httpClientProvider.createHttpClient(destination);
    }

    @Nonnull
    protected HttpClient getHttpClient(@Nonnull HttpClientFactory httpClientProvider) throws HttpClientInstantiationException {
        Optional<Cache<CacheKey, HttpClient>> cache = this.getCache();
        CacheKey key = this.getCacheKey();
        if (cache.isPresent()) {
            Cache<CacheKey, HttpClient> actualCache = cache.get();
            try {
                return (HttpClient)actualCache.get((Object)key, httpClientProvider::createHttpClient);
            }
            catch (ExecutionException e) {
                throw new HttpClientInstantiationException(e);
            }
        }
        return httpClientProvider.createHttpClient();
    }

    @Nonnull
    protected abstract Optional<Cache<CacheKey, HttpClient>> getCache() throws HttpClientInstantiationException;

    @Nonnull
    protected abstract CacheKey getCacheKey(@Nonnull Destination var1) throws HttpClientInstantiationException;

    @Nonnull
    protected abstract CacheKey getCacheKey() throws HttpClientInstantiationException;
}

