/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.security.Credentials;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProxyConfiguration {
    private final URI uri;
    @Nullable
    private final Credentials credentials;

    public ProxyConfiguration(URI uri) {
        this(uri, null);
    }

    public ProxyConfiguration(@Nonnull URI uri, @Nullable Credentials credentials) {
        this.uri = uri;
        this.credentials = credentials;
    }

    public Optional<Credentials> getCredentials() {
        return Optional.ofNullable(this.credentials);
    }

    public static ProxyConfiguration of(URI uri, @Nullable Credentials credentials) {
        return new ProxyConfiguration(uri, credentials);
    }

    public static ProxyConfiguration of(URI uri) {
        return new ProxyConfiguration(uri);
    }

    public static ProxyConfiguration of(String uri, @Nullable Credentials credentials) throws IllegalArgumentException {
        return new ProxyConfiguration(URI.create(uri), credentials);
    }

    public static ProxyConfiguration of(String uri) throws IllegalArgumentException {
        return new ProxyConfiguration(URI.create(uri));
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyConfiguration)) {
            return false;
        }
        ProxyConfiguration other = (ProxyConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        Optional<Credentials> this$credentials = this.getCredentials();
        Optional<Credentials> other$credentials = other.getCredentials();
        return !(this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProxyConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        Optional<Credentials> $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        return result;
    }

    public String toString() {
        return "ProxyConfiguration(uri=" + this.getUri() + ", credentials=" + this.getCredentials() + ")";
    }
}

