/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public enum ProxyType {
    INTERNET("Internet"),
    ON_PREMISE("OnPremise");

    private static final Logger logger;
    private final String identifier;

    private ProxyType(String identifier) {
        this.identifier = identifier;
    }

    public String toString() {
        return this.identifier;
    }

    @Nonnull
    public static ProxyType ofIdentifier(@Nonnull String identifier) throws IllegalArgumentException {
        for (ProxyType proxyType : ProxyType.values()) {
            if (!proxyType.getIdentifier().equals(identifier)) continue;
            return proxyType;
        }
        throw new IllegalArgumentException("Unknown " + ProxyType.class.getSimpleName() + ": " + identifier + ".");
    }

    @Nonnull
    public static ProxyType ofIdentifierOrDefault(@Nullable String identifier, @Nonnull ProxyType defaultProxyType) {
        if (identifier == null) {
            return defaultProxyType;
        }
        try {
            return ProxyType.ofIdentifier(identifier);
        }
        catch (IllegalArgumentException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(ProxyType.class.getSimpleName() + " \"" + identifier + "\" is not supported. Falling back to " + (Object)((Object)defaultProxyType) + ".");
            }
            return defaultProxyType;
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    static {
        logger = CloudLoggerFactory.getLogger(ProxyType.class);
    }
}

