/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationPathsNotMergeableException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;

public class UriPathMerger {
    private static final Logger logger = CloudLoggerFactory.getLogger(UriPathMerger.class);

    @Nonnull
    public URI merge(@Nonnull URI destinationUri, @Nullable URI requestUri) throws DestinationPathsNotMergeableException {
        try {
            if (requestUri != null) {
                String requestPath = requestUri.getRawPath();
                if (logger.isDebugEnabled()) {
                    logger.debug("Merging request path: " + requestPath);
                }
                String destinationUriPath = destinationUri.getRawPath();
                this.assertRequestUriMatchesDestinationUri(destinationUri, requestUri);
                if (logger.isDebugEnabled()) {
                    logger.debug("Successfully merged request path: " + requestPath);
                }
                if (!requestUri.isAbsolute()) {
                    requestPath = this.mergeUriPaths(destinationUriPath, requestPath);
                }
                return new URIBuilder(destinationUri).setUserInfo(requestUri.getRawUserInfo()).setPath(requestPath).setCustomQuery(requestUri.getQuery()).setFragment(requestUri.getFragment()).build();
            }
            String requestPath = destinationUri.getRawPath();
            requestPath = requestPath.replaceAll("^/", "");
            requestPath = "/" + requestPath;
            return new URIBuilder(destinationUri).setPath(requestPath).build();
        }
        catch (URISyntaxException e) {
            throw new ShouldNotHappenException("Failed to merge request URI.", (Throwable)e);
        }
    }

    private void assertRequestUriMatchesDestinationUri(@Nonnull URI destinationUri, @Nonnull URI requestUri) throws DestinationPathsNotMergeableException {
        if (requestUri.getHost() != null) {
            boolean isPortEqual;
            boolean isSchemeEqual = destinationUri.getScheme().equalsIgnoreCase(requestUri.getScheme());
            boolean isHostEqual = destinationUri.getHost().equalsIgnoreCase(requestUri.getHost());
            boolean bl = isPortEqual = destinationUri.getPort() == requestUri.getPort();
            if (!(isSchemeEqual && isHostEqual && isPortEqual)) {
                throw new DestinationPathsNotMergeableException("URIs defined in destination \"" + destinationUri + "\" and supplied by application code \"" + requestUri + "\" differ.");
            }
        }
    }

    @Nonnull
    private String mergeUriPaths(@Nullable String firstPath, @Nullable String secondPath) throws DestinationPathsNotMergeableException {
        if (firstPath == null || secondPath == null) {
            throw new DestinationPathsNotMergeableException("Cannot merge URI paths that are null.");
        }
        String first = firstPath.trim().replaceFirst("^/", "");
        String second = secondPath.trim().replaceFirst("^/", "");
        String result = second.isEmpty() ? first : (second.startsWith(first) ? second : (first.endsWith("/") ? first : first + "/") + second);
        return result.startsWith("/") ? result : "/" + result;
    }
}

