/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity.exception;

import com.sap.cloud.sdk.cloudplatform.servlet.response.DestinationErrorResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DestinationNotFoundException
extends RuntimeException
implements WithErrorResponse {
    private static final long serialVersionUID = 8880115609598781458L;
    @Nullable
    private final String destinationName;

    public DestinationNotFoundException() {
        this((String)null);
    }

    public DestinationNotFoundException(@Nullable String destinationName) {
        super("Destination " + (destinationName != null ? "\"" + destinationName + "\"" : "") + " not found.");
        this.destinationName = destinationName;
    }

    public DestinationNotFoundException(@Nullable String destinationName, String message) {
        super(message);
        this.destinationName = destinationName;
    }

    public DestinationNotFoundException(@Nullable String destinationName, String message, Throwable cause) {
        super(message, cause);
        this.destinationName = destinationName;
    }

    @Nonnull
    public ResponseWithErrorCode getErrorResponse() {
        return new DestinationErrorResponse(this.destinationName, this.getMessage());
    }

    @Nullable
    public String getDestinationName() {
        return this.destinationName;
    }
}

