/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.RefreshJwtTokenCommand;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

class AuthTokenDecoder {
    private static final String BEARER_PREFIX = "Bearer ";

    AuthTokenDecoder() {
    }

    private int getNumberOfAuthHeaders(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        int numHeaders = 0;
        if (headers != null) {
            while (headers.hasMoreElements()) {
                headers.nextElement();
                ++numHeaders;
            }
        }
        return numHeaders;
    }

    private ScpCfCloudPlatform getCloudPlatform() {
        CloudPlatform cloudPlatform = CloudPlatformAccessor.getCloudPlatform();
        if (!(cloudPlatform instanceof ScpCfCloudPlatform)) {
            throw new ShouldNotHappenException("The current Cloud platform is not an instance of " + ScpCfCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:core-scp-cf.");
        }
        return (ScpCfCloudPlatform)cloudPlatform;
    }

    @Nonnull
    private RSAPublicKey getVerificationPublicKey(@Nonnull String encodedJwt) throws AuthTokenAccessException {
        JsonObject xsuaaServiceCredentials;
        try {
            DecodedJWT decodedJWT = JWT.decode((String)encodedJwt);
            xsuaaServiceCredentials = this.getCloudPlatform().getXsuaaServiceCredentials(decodedJWT);
        }
        catch (JWTDecodeException | CloudPlatformException e) {
            throw new AuthTokenAccessException("Failed to verify JWT bearer.", e);
        }
        JsonElement verificationKey = xsuaaServiceCredentials.get("verificationkey");
        if (verificationKey == null) {
            throw new AuthTokenAccessException("Failed to verify JWT bearer: no verification key found in XSUAA service credentials.");
        }
        String publicKey = verificationKey.getAsString().replaceAll("\\n", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKey));
            return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AuthTokenAccessException("Failed to verify JWT bearer.", e);
        }
    }

    @Nonnull
    private Algorithm getVerificationAlgorithm(@Nonnull RSAPublicKey verificationKey, @Nonnull String tokenValue) throws AuthTokenAccessException {
        try {
            String algorithmIdentifier = JWT.decode((String)tokenValue).getAlgorithm();
            if (algorithmIdentifier == null) {
                throw new AuthTokenAccessException("Failed to verify JWT bearer: no algorithm specified in token header.");
            }
            switch (algorithmIdentifier) {
                case "RS256": {
                    return Algorithm.RSA256((RSAPublicKey)verificationKey, null);
                }
                case "RS384": {
                    return Algorithm.RSA384((RSAPublicKey)verificationKey, null);
                }
                case "RS512": {
                    return Algorithm.RSA512((RSAPublicKey)verificationKey, null);
                }
            }
            throw new AuthTokenAccessException("Failed to verify JWT bearer: algorithm '" + algorithmIdentifier + "' not supported.");
        }
        catch (JWTDecodeException | IllegalArgumentException e) {
            throw new AuthTokenAccessException("Failed to verify JWT bearer.", e);
        }
    }

    @Nonnull
    AuthToken decode(@Nonnull String encodedJwt, @Nullable String refreshToken) throws AuthTokenAccessException {
        RSAPublicKey verificationKey = this.getVerificationPublicKey(encodedJwt);
        Algorithm verificationAlgorithm = this.getVerificationAlgorithm(verificationKey, encodedJwt);
        try {
            DecodedJWT jwt;
            JWTVerifier verifier = JWT.require((Algorithm)verificationAlgorithm).build();
            try {
                jwt = verifier.verify(encodedJwt);
            }
            catch (TokenExpiredException e) {
                jwt = Optional.ofNullable(refreshToken).map(token -> {
                    String refreshedEncodedJwt = new RefreshJwtTokenCommand(encodedJwt, refreshToken).run();
                    return verifier.verify(refreshedEncodedJwt);
                }).orElseThrow(() -> e);
            }
            return new AuthToken(jwt);
        }
        catch (JWTVerificationException | IllegalArgumentException e) {
            throw new AuthTokenAccessException("Failed to verify JWT bearer.", e);
        }
    }

    @Nonnull
    Optional<AuthToken> decode(@Nonnull HttpServletRequest request) throws AuthTokenAccessException {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader == null) {
            return Optional.empty();
        }
        if (this.getNumberOfAuthHeaders(request) != 1) {
            throw new AuthTokenAccessException("Failed to decode JWT bearer: multiple 'Authorization' headers present in request.");
        }
        if (!authorizationHeader.startsWith(BEARER_PREFIX)) {
            throw new AuthTokenAccessException("Failed to decode JWT bearer: no JWT bearer present in 'Authorization' header of request.");
        }
        String tokenValue = authorizationHeader.substring(BEARER_PREFIX.length());
        return Optional.of(this.decode(tokenValue, null));
    }
}

