/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenRequest;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextExecutor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import java.util.Optional;
import javax.annotation.Nonnull;

public class AuthTokenFacade {
    @Nonnull
    public Optional<AuthToken> getCurrentToken() throws AuthTokenAccessException {
        Optional property;
        Optional requestContext = RequestContextAccessor.getCurrentRequestContext();
        if (!requestContext.isPresent()) {
            throw new AuthTokenAccessException("Failed to get authorization token: no " + RequestContext.class.getSimpleName() + " available. Have you correctly configured a " + RequestContextServletFilter.class.getSimpleName() + " or have you wrapped your logic in a " + RequestContextExecutor.class.getSimpleName() + " when executing background tasks that are not triggered by a request?");
        }
        try {
            property = ((RequestContext)requestContext.get()).getProperty(AuthTokenRequestContextListener.PROPERTY_AUTH_TOKEN);
        }
        catch (RequestContextPropertyException e) {
            throw new AuthTokenAccessException("Failed to get authorization token.", e);
        }
        if (!property.isPresent()) {
            throw new AuthTokenAccessException("Failed to get authorization token: " + RequestContext.class.getSimpleName() + " property '" + AuthTokenRequestContextListener.PROPERTY_AUTH_TOKEN + "' not initialized. Have you correctly configured a " + AuthTokenRequestContextListener.class.getSimpleName() + " in the relevant " + RequestContextServletFilter.class.getSimpleName() + " or " + RequestContextExecutor.class.getSimpleName() + "?");
        }
        Exception exception = ((Property)property.get()).getException();
        if (exception != null) {
            throw new AuthTokenAccessException("Failed to get authorization token.", exception);
        }
        AuthToken value = (AuthToken)((Property)property.get()).getValue();
        return Optional.ofNullable(value);
    }

    @Nonnull
    public AuthToken getXsuaaServiceToken() throws TokenRequestFailedException {
        return new AuthTokenRequest().getXsuaaServiceToken();
    }
}

