/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenDecoder;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.servlet.AbstractRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;

public class AuthTokenRequestContextListener
extends AbstractRequestContextListener {
    private static final Logger logger = CloudLoggerFactory.getLogger(AuthTokenRequestContextListener.class);
    static final String PROPERTY_AUTH_TOKEN = AuthTokenRequestContextListener.class.getName() + ":authToken";

    public int getPriority() {
        return -5;
    }

    @Nonnull
    protected Map<String, Property<?>> getProperties(@Nonnull RequestContext requestContext) {
        Property property;
        HashMap properties = new HashMap();
        Optional request = requestContext.getRequest();
        if (request.isPresent()) {
            try {
                property = Property.ofConfidentialValue(new AuthTokenDecoder().decode((HttpServletRequest)request.get()).orElse(null));
            }
            catch (AuthTokenAccessException e) {
                property = Property.ofConfidentialException((Exception)e);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to initialize " + ((Object)((Object)this)).getClass().getSimpleName() + ": no request available.");
            }
            property = Property.empty();
        }
        properties.put(PROPERTY_AUTH_TOKEN, property);
        return properties;
    }
}

