/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.JsonElement;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenDecoder;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import com.sap.cloud.sdk.cloudplatform.servlet.AbstractRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.BaseRequestContextExecutor;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JwtBasedRequestContextExecutor
extends BaseRequestContextExecutor<JwtBasedRequestContextExecutor> {
    @Deprecated
    @Nonnull
    public JwtBasedRequestContextExecutor onBehalfOfTenant(@Nonnull String tenantId, @Nullable String issuerUrl, String ... audiences) {
        if (issuerUrl == null) {
            issuerUrl = this.getSubscriberIssuer(tenantId).toString();
        }
        if (audiences.length < 1) {
            audiences = new String[]{((ScpCfCloudPlatform)CloudPlatformAccessor.getCloudPlatform()).getXsAppName()};
        }
        return this.onBehalfOfTenant(tenantId, issuerUrl, Arrays.asList(audiences));
    }

    @Nonnull
    public JwtBasedRequestContextExecutor onBehalfOfTenant(@Nonnull String tenantId) {
        URI uri = this.getSubscriberIssuer(tenantId);
        String xsAppName = ((ScpCfCloudPlatform)CloudPlatformAccessor.getCloudPlatform()).getXsAppName();
        return this.onBehalfOfTenant(tenantId, uri.toString(), Collections.singletonList(xsAppName));
    }

    @Nonnull
    public JwtBasedRequestContextExecutor onBehalfOfTenant(@Nonnull String tenantId, @Nonnull String issuerUrl, @Nonnull Collection<String> audiences) {
        String encodedJwt = JWT.create().withClaim("zid", tenantId).withClaim("iss", issuerUrl).withAudience(audiences.toArray(new String[0])).sign(Algorithm.none());
        DecodedJWT decodedJwt = JWT.decode((String)encodedJwt);
        AuthToken authToken = new AuthToken(decodedJwt);
        return (JwtBasedRequestContextExecutor)((JwtBasedRequestContextExecutor)this.withoutListener(AuthTokenRequestContextListener.class)).withListeners(new RequestContextListener[]{new JwtBasedAuthTokenRequestContextListener(() -> authToken)});
    }

    @Nonnull
    public JwtBasedRequestContextExecutor withJwt(@Nonnull String encodedJwt) {
        return (JwtBasedRequestContextExecutor)((JwtBasedRequestContextExecutor)this.withoutListener(AuthTokenRequestContextListener.class)).withListeners(new RequestContextListener[]{new JwtBasedAuthTokenRequestContextListener(() -> new AuthTokenDecoder().decode(encodedJwt, null))});
    }

    @Nonnull
    public JwtBasedRequestContextExecutor withJwt(@Nonnull String encodedJwt, @Nonnull String refreshToken) {
        return (JwtBasedRequestContextExecutor)((JwtBasedRequestContextExecutor)this.withoutListener(AuthTokenRequestContextListener.class)).withListeners(new RequestContextListener[]{new JwtBasedAuthTokenRequestContextListener(() -> new AuthTokenDecoder().decode(encodedJwt, refreshToken))});
    }

    @Nonnull
    public JwtBasedRequestContextExecutor withXsuaaServiceJwt() {
        AuthToken authToken = AuthTokenAccessor.getXsuaaServiceToken();
        return (JwtBasedRequestContextExecutor)((JwtBasedRequestContextExecutor)this.withoutListener(AuthTokenRequestContextListener.class)).withListeners(new RequestContextListener[]{new JwtBasedAuthTokenRequestContextListener(() -> authToken)});
    }

    @Nonnull
    protected JwtBasedRequestContextExecutor getThis() {
        return this;
    }

    private URI getSubscriberIssuer(@Nonnull String tenantId) throws TokenRequestFailedException {
        JsonElement url = ScpCfCloudPlatform.getInstanceOrThrow().getXsuaaServiceCredentials().get("url");
        if (url == null || !url.isJsonPrimitive()) {
            throw new TokenRequestFailedException("Failed to get XSUAA service URI.");
        }
        try {
            URI uri = new URI(url.getAsString());
            return new URI(uri.getScheme(), null, tenantId + uri.getHost().substring(uri.getHost().indexOf(".")), uri.getPort(), uri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new TokenRequestFailedException(e);
        }
    }

    private static final class JwtBasedAuthTokenRequestContextListener
    extends AbstractRequestContextListener {
        @Nonnull
        private final Supplier<AuthToken> authTokenSupplier;

        @Nonnull
        protected Map<String, Property<?>> getProperties(@Nonnull RequestContext requestContext) {
            Property property;
            try {
                AuthToken authToken = this.authTokenSupplier.get();
                property = Property.ofConfidentialValue((Object)authToken);
            }
            catch (AuthTokenAccessException e) {
                property = Property.ofConfidentialException((Exception)e);
            }
            return Collections.singletonMap(AuthTokenRequestContextListener.PROPERTY_AUTH_TOKEN, property);
        }

        public int getPriority() {
            return -5;
        }

        public JwtBasedAuthTokenRequestContextListener(@Nonnull Supplier<AuthToken> authTokenSupplier) {
            if (authTokenSupplier == null) {
                throw new NullPointerException("authTokenSupplier is marked @NonNull but is null");
            }
            this.authTokenSupplier = authTokenSupplier;
        }
    }
}

