/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Payload;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessException;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalFacade;
import com.sap.cloud.sdk.cloudplatform.security.principal.ScpCfPrincipal;
import com.sap.cloud.sdk.cloudplatform.security.user.LocalScopePrefixExtractor;
import com.sap.cloud.sdk.cloudplatform.security.user.LocalScopePrefixProvider;
import com.sap.cloud.sdk.cloudplatform.security.user.ScopeAccessException;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScpCfPrincipalFacade
implements PrincipalFacade {
    private static final String JWT_CLIENT_ID_CLAIM = "client_id";
    private static final String JWT_USER_NAME_CLAIM = "user_name";
    private static final String JWT_GRANT_TYPE_CLAIM = "grant_type";
    private final LocalScopePrefixExtractor localScopePrefixExtractor;
    private final Map<String, CheckedFunction1<DecodedJWT, String>> grantTypeToIdExtractor = new HashMap<String, CheckedFunction1<DecodedJWT, String>>();

    public ScpCfPrincipalFacade(@Nullable LocalScopePrefixProvider localScopePrefixProvider) {
        this.localScopePrefixExtractor = new LocalScopePrefixExtractor(localScopePrefixProvider);
        this.grantTypeToIdExtractor.put("password", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
        this.grantTypeToIdExtractor.put("client_credentials", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_CLIENT_ID_CLAIM).asString());
        this.grantTypeToIdExtractor.put("authorization_code", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
    }

    public ScpCfPrincipalFacade() {
        this(null);
    }

    public void setIdExtractorFunction(@Nonnull String grantType, @Nonnull CheckedFunction1<DecodedJWT, String> idExtractor) {
        this.grantTypeToIdExtractor.put(grantType, idExtractor);
    }

    @Nonnull
    public Principal getCurrentPrincipal() throws PrincipalAccessException {
        Optional<AuthToken> authToken;
        try {
            authToken = AuthTokenAccessor.getCurrentToken();
        }
        catch (AuthTokenAccessException e) {
            throw new PrincipalAccessException("Failed to retrieve current authorization token.", (Throwable)e);
        }
        if (!authToken.isPresent()) {
            throw new PrincipalAccessException("The current Request Context did not contain an authorization token.");
        }
        DecodedJWT jwt = authToken.get().getJwt();
        return new ScpCfPrincipal(this.getPrincipalId(jwt), this.getAuthorizations((Payload)jwt));
    }

    private String getPrincipalId(DecodedJWT jwt) throws PrincipalAccessException {
        String principalId;
        Claim grantTypeClaim = jwt.getClaim(JWT_GRANT_TYPE_CLAIM);
        if (grantTypeClaim.isNull()) {
            throw new PrincipalAccessException("The current JWT does not contain any grant type.");
        }
        String grantType = grantTypeClaim.asString();
        CheckedFunction1<DecodedJWT, String> idSupplier = this.grantTypeToIdExtractor.get(grantType);
        if (idSupplier == null) {
            throw new PrincipalAccessException("There is no reader registered for grant type '" + grantType + "'.");
        }
        try {
            principalId = (String)idSupplier.apply((Object)jwt);
        }
        catch (Throwable throwable) {
            throw new PrincipalAccessException("Could not read id for grant type " + grantType + " from JWT.", throwable);
        }
        if (principalId == null) {
            throw new PrincipalAccessException("The principalId for grant type " + grantType + " must not be null.");
        }
        return principalId;
    }

    private Set<Authorization> getAuthorizations(@Nonnull Payload jwt) throws PrincipalAccessException {
        try {
            return this.localScopePrefixExtractor.getAuthorizations(jwt);
        }
        catch (ScopeAccessException e) {
            throw new PrincipalAccessException((Throwable)e);
        }
    }
}

