/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Payload;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.security.user.AbstractUser;
import com.sap.cloud.sdk.cloudplatform.security.user.LocalScopePrefixExtractor;
import com.sap.cloud.sdk.cloudplatform.security.user.LocalScopePrefixProvider;
import com.sap.cloud.sdk.cloudplatform.security.user.ScopeAccessException;
import com.sap.cloud.sdk.cloudplatform.security.user.StringCollectionUserAttribute;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAttribute;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ScpCfUser
extends AbstractUser {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpCfUser.class);
    private static final String JWT_USER_NAME = "user_name";
    private static final String JWT_SCOPES = "scope";
    private static final String JWT_USER_ATTRIBUTES = "xs.user.attributes";
    private static final String JWT_GRANT_TYPE = "grant_type";
    private static final String JWT_GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";

    @Nullable
    private static String getUserName(@Nonnull Payload jwt) throws UserAccessException {
        return jwt.getClaim(JWT_USER_NAME).asString();
    }

    @Nonnull
    private static Set<Authorization> getAuthorizations(@Nonnull Payload jwt, @Nonnull LocalScopePrefixProvider prefixProvider) throws UserAccessException {
        try {
            return new LocalScopePrefixExtractor(prefixProvider).getAuthorizations(jwt);
        }
        catch (ScopeAccessException e) {
            throw new UserAccessException((Throwable)e);
        }
    }

    @Nonnull
    private static Map<String, UserAttribute> getAttributes(@Nonnull Payload jwt) throws UserAccessException {
        Map attributesMap;
        HashMap<String, UserAttribute> attributes = new HashMap<String, UserAttribute>();
        try {
            attributesMap = jwt.getClaim(JWT_USER_ATTRIBUTES).asMap();
        }
        catch (JWTDecodeException e) {
            throw new UserAccessException("Failed to get user attributes.", (Throwable)e);
        }
        if (attributesMap != null) {
            String grantType = jwt.getClaim(JWT_GRANT_TYPE).asString();
            if (JWT_GRANT_TYPE_CLIENT_CREDENTIALS.equals(grantType)) {
                throw new UserAccessException("Retrieving 'xs.user.attributes' is not supported for grant type client_credentials.");
            }
            for (Map.Entry entry : attributesMap.entrySet()) {
                if (!(entry.getValue() instanceof Iterable)) {
                    throw new UserAccessException("Failed to get user attributes: value of attribute map entry is not an instance of Iterable.");
                }
                Iterable iterable = (Iterable)entry.getValue();
                ArrayList<String> values = new ArrayList<String>();
                for (Object value : iterable) {
                    if (!(value instanceof String)) {
                        throw new UserAccessException("Failed to get user attributes: value is not a String.");
                    }
                    values.add((String)value);
                }
                String name = (String)entry.getKey();
                attributes.put(name, (UserAttribute)new StringCollectionUserAttribute(name, values));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Skipping reading of user attributes: cannot find field 'xs.user.attributes' in authorization token.");
        }
        return attributes;
    }

    public ScpCfUser(@Nonnull String name, @Nullable Locale locale, @Nonnull Set<Authorization> authorizations, @Nonnull Map<String, UserAttribute> attributes) {
        super(name, locale, authorizations, attributes);
    }

    @Nullable
    static ScpCfUser ofCurrentUser(@Nonnull LocalScopePrefixProvider localScopePrefixProvider) throws UserAccessException {
        Optional<AuthToken> authToken;
        try {
            authToken = AuthTokenAccessor.getCurrentToken();
        }
        catch (AuthTokenAccessException e) {
            throw new UserAccessException("Failed to get user from current authorization token.", (Throwable)e);
        }
        if (!authToken.isPresent()) {
            return null;
        }
        DecodedJWT jwt = authToken.get().getJwt();
        String userName = ScpCfUser.getUserName((Payload)jwt);
        if (userName == null) {
            return null;
        }
        return new ScpCfUser(userName, null, ScpCfUser.getAuthorizations((Payload)jwt, localScopePrefixProvider), ScpCfUser.getAttributes((Payload)jwt));
    }

    @Nonnull
    static ScpCfUser ofMockedUser() {
        return new ScpCfUser();
    }

    private ScpCfUser() {
        this("", null, Collections.emptySet(), Collections.emptyMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScpCfUser)) {
            return false;
        }
        ScpCfUser other = (ScpCfUser)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScpCfUser;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        return "ScpCfUser(super=" + super.toString() + ")";
    }
}

