/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.sap.cloud.sdk.cloudplatform.exception.UnsupportedCloudFeatureException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.user.AbstractUserFacade;
import com.sap.cloud.sdk.cloudplatform.security.user.DefaultLocalScopePrefixProvider;
import com.sap.cloud.sdk.cloudplatform.security.user.LocalScopePrefixProvider;
import com.sap.cloud.sdk.cloudplatform.security.user.ScpCfUser;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ScpCfUserFacade
extends AbstractUserFacade {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpCfUserFacade.class);
    public static final String VARIABLE_ALLOW_MOCKED_AUTH_HEADER = "ALLOW_MOCKED_AUTH_HEADER";
    private final LocalScopePrefixProvider localScopePrefixProvider;

    public ScpCfUserFacade(@Nullable LocalScopePrefixProvider localScopePrefixProvider) {
        this.localScopePrefixProvider = localScopePrefixProvider != null ? localScopePrefixProvider : new DefaultLocalScopePrefixProvider();
    }

    public ScpCfUserFacade() {
        this(null);
    }

    @Nonnull
    public Class<ScpCfUser> getUserClass() {
        return ScpCfUser.class;
    }

    @Nonnull
    protected User newMockedUser() {
        return ScpCfUser.ofMockedUser();
    }

    @Nonnull
    protected Optional<User> getMockedUserAsFallback() {
        String env = System.getenv(VARIABLE_ALLOW_MOCKED_AUTH_HEADER);
        if (Boolean.valueOf(env).booleanValue()) {
            logger.error("Falling back to mocked user with blank user name and no authorizations since the user is not authenticated and environment variable 'ALLOW_MOCKED_AUTH_HEADER' is set to 'true'. SECURITY WARNING: This variable must never be used in productive environments! For details on the security configuration, please refer to the SAP Cloud Platform documentation. Tutorials on the configuration are available at 'https://help.sap.com/viewer/p/SAP_CLOUD_SDK'.");
            return Optional.of(this.newMockedUser());
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<User> resolveCurrentUser() throws UserAccessException {
        Optional mockedUser = this.getMockedUser();
        if (mockedUser.isPresent()) {
            return mockedUser;
        }
        ScpCfUser currentUser = ScpCfUser.ofCurrentUser(this.localScopePrefixProvider);
        if (currentUser != null) {
            return Optional.of(currentUser);
        }
        return this.getMockedUserAsFallback();
    }

    @Nonnull
    public Optional<User> getUserByName(String name) {
        throw new UnsupportedCloudFeatureException("Getting users by name is not yet supported on SAP Cloud Platform Cloud Foundry.");
    }
}

