/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenFacade;
import com.sap.cloud.sdk.cloudplatform.security.RefreshTokenFacade;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import java.util.Optional;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;

public class AuthTokenAccessor {
    @Nonnull
    private static AuthTokenFacade authTokenFacade = new AuthTokenFacade();
    @Nonnull
    private static RefreshTokenFacade refreshTokenFacade = new RefreshTokenFacade();

    @Nonnull
    public static AuthTokenFacade getAuthTokenFacade() {
        return authTokenFacade;
    }

    public static void setAuthTokenFacade(@Nonnull AuthTokenFacade authTokenFacade) {
        AuthTokenAccessor.authTokenFacade = authTokenFacade;
    }

    public static void setRefreshTokenFacade(@Nonnull RefreshTokenFacade refreshTokenFacade) {
        AuthTokenAccessor.refreshTokenFacade = refreshTokenFacade;
    }

    @Nonnull
    public static Optional<AuthToken> getCurrentToken() throws AuthTokenAccessException {
        return authTokenFacade.getCurrentToken();
    }

    @Nonnull
    public static AuthToken getXsuaaServiceToken() throws TokenRequestFailedException {
        return authTokenFacade.getXsuaaServiceToken();
    }

    @Nonnull
    public static Future<String> getRefreshToken(@Nonnull DecodedJWT jwt) {
        return refreshTokenFacade.getRefreshToken(jwt);
    }
}

