/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenValidator;
import com.sap.cloud.sdk.cloudplatform.security.RefreshJwtTokenCommand;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

class AuthTokenDecoder {
    private static final String BEARER_PREFIX = "bearer ";

    AuthTokenDecoder() {
    }

    private int getNumberOfAuthHeaders(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        int numHeaders = 0;
        if (headers != null) {
            while (headers.hasMoreElements()) {
                headers.nextElement();
                ++numHeaders;
            }
        }
        return numHeaders;
    }

    @Nonnull
    AuthToken decode(@Nonnull String encodedJwt, @Nullable String refreshToken) throws AuthTokenAccessException {
        List<RSAPublicKey> verificationKeys = AuthTokenValidator.getVerificationPublicKeysForJwt(encodedJwt);
        String targetAlgorithm = (String)Try.of((CheckedFunction0 & Serializable)() -> JWT.decode((String)encodedJwt).getAlgorithm()).getOrElseThrow(e -> new AuthTokenAccessException("Failed to verify JWT bearer.", (Throwable)e));
        AuthTokenValidator authTokenValidator = new AuthTokenValidator(targetAlgorithm, verificationKeys);
        Optional<DecodedJWT> verifiedToken = authTokenValidator.verifyToken(encodedJwt);
        if (!verifiedToken.isPresent() && refreshToken != null) {
            String refreshedEncodedJwt = new RefreshJwtTokenCommand(encodedJwt, refreshToken).run();
            verifiedToken = authTokenValidator.verifyToken(refreshedEncodedJwt);
        }
        return verifiedToken.map(AuthToken::new).orElseThrow(() -> new AuthTokenAccessException("Failed to verify JWT bearer."));
    }

    @Nonnull
    Optional<AuthToken> decode(@Nonnull HttpServletRequest request) throws AuthTokenAccessException {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader == null) {
            return Optional.empty();
        }
        if (this.getNumberOfAuthHeaders(request) != 1) {
            throw new AuthTokenAccessException("Failed to decode JWT bearer: multiple 'Authorization' headers present in request.");
        }
        if (!authorizationHeader.toLowerCase(Locale.ENGLISH).startsWith(BEARER_PREFIX)) {
            throw new AuthTokenAccessException("Failed to decode JWT bearer: no JWT bearer present in 'Authorization' header of request.");
        }
        String tokenValue = authorizationHeader.substring(BEARER_PREFIX.length());
        return Optional.of(this.decode(tokenValue, null));
    }
}

