/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.json.JsonSanitizer;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpEntityUtil;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenDecoder;
import com.sap.cloud.sdk.cloudplatform.security.BasicAuthHeaderEncoder;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;

class AuthTokenRequest {
    private final AuthTokenDecoder decoder;

    AuthTokenRequest(@Nullable AuthTokenDecoder decoder) {
        this.decoder = decoder == null ? new AuthTokenDecoder() : decoder;
    }

    AuthTokenRequest() {
        this(null);
    }

    @Nonnull
    AuthToken getXsuaaServiceToken() throws TokenRequestFailedException {
        ScpCfCloudPlatform cloudPlatform = this.getCloudPlatform();
        JsonObject xsuaaCredentials = cloudPlatform.getXsuaaServiceCredentials();
        return this.getXsuaaServiceToken(xsuaaCredentials);
    }

    private AuthToken getXsuaaServiceToken(JsonObject xsuaaServiceCredentials) throws TokenRequestFailedException {
        String accessToken = (String)Try.of((CheckedFunction0 & Serializable)() -> {
            String clientId = xsuaaServiceCredentials.get("clientid").getAsString();
            String clientSecret = xsuaaServiceCredentials.get("clientsecret").getAsString();
            String xsuaaUrl = xsuaaServiceCredentials.get("url").getAsString();
            BasicCredentials clientCredentials = new BasicCredentials(clientId, clientSecret);
            URI requestUri = new URI(xsuaaUrl).resolve("/oauth/token?grant_type=client_credentials");
            HttpPost request = new HttpPost(requestUri);
            request.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
            request.setHeader("Authorization", "Basic " + BasicAuthHeaderEncoder.encodeUserPasswordBase64((BasicCredentials)clientCredentials));
            HttpResponse response = HttpClientAccessor.getHttpClient().execute((HttpUriRequest)request);
            return this.extractAccessToken(response);
        }).getOrElseThrow(TokenRequestFailedException::new);
        return this.decoder.decode(accessToken, null);
    }

    @Nullable
    private String extractAccessToken(HttpResponse response) throws IOException {
        String responseBody = HttpEntityUtil.getResponseBody((HttpResponse)response);
        JsonObject responseBodyJson = new JsonParser().parse(JsonSanitizer.sanitize((String)responseBody)).getAsJsonObject();
        return responseBodyJson.get("access_token").getAsString();
    }

    private ScpCfCloudPlatform getCloudPlatform() {
        CloudPlatform cloudPlatform = CloudPlatformAccessor.getCloudPlatform();
        if (!(cloudPlatform instanceof ScpCfCloudPlatform)) {
            throw new ShouldNotHappenException("The current Cloud platform is not an instance of " + ScpCfCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:core-scp-cf.");
        }
        return (ScpCfCloudPlatform)cloudPlatform;
    }
}

