/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.JWT;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.json.JsonSanitizer;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpEntityUtil;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.RefreshTokenRetrievalCommand;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import com.sap.cloud.sdk.frameworks.hystrix.Command;
import com.sap.cloud.sdk.frameworks.hystrix.HystrixUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

class RefreshJwtTokenCommand
extends Command<String> {
    private final String encodedJwt;
    private final String refreshToken;

    RefreshJwtTokenCommand(@Nonnull String encodedJwt, @Nonnull String refreshToken) {
        super(new CommandSetterBuilder(RefreshTokenRetrievalCommand.class).build());
        this.encodedJwt = encodedJwt;
        this.refreshToken = refreshToken;
    }

    protected String run() {
        String responseBody;
        HttpResponse response;
        URI uri;
        CloudPlatform cloudPlatform = CloudPlatformAccessor.getCloudPlatform();
        if (!(cloudPlatform instanceof ScpCfCloudPlatform)) {
            throw new ShouldNotHappenException("The current Cloud platform is not an instance of " + ScpCfCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:core-scp-cf.");
        }
        JsonObject xsuaaServiceCredentials = ((ScpCfCloudPlatform)cloudPlatform).getXsuaaServiceCredentials(JWT.decode((String)this.encodedJwt));
        String clientid = xsuaaServiceCredentials.get("clientid").getAsString();
        String xsuaaUrl = xsuaaServiceCredentials.get("url").getAsString();
        String clientSecret = xsuaaServiceCredentials.get("clientsecret").getAsString();
        try {
            uri = new URI((xsuaaUrl.endsWith("/") ? xsuaaUrl : xsuaaUrl + "/") + "oauth/token");
        }
        catch (URISyntaxException e) {
            throw new TokenRequestFailedException(e);
        }
        HttpPost tokenRequest = new HttpPost(uri);
        tokenRequest.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
        tokenRequest.setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
        try {
            tokenRequest.setEntity((HttpEntity)new StringEntity("client_id=" + clientid + "&client_secret=" + clientSecret + "&grant_type=refresh_token&token_format=jwt&refresh_token=" + this.refreshToken));
        }
        catch (UnsupportedEncodingException e) {
            throw new TokenRequestFailedException(e);
        }
        try {
            response = HttpClientAccessor.getHttpClient().execute((HttpUriRequest)tokenRequest);
        }
        catch (IOException e) {
            throw new TokenRequestFailedException(e);
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 400 && statusCode <= 599) {
            throw new TokenRequestFailedException("Refresh JWT request failed with status code " + statusCode + ": " + response.getStatusLine().getReasonPhrase());
        }
        try {
            responseBody = HttpEntityUtil.getResponseBody((HttpResponse)response);
        }
        catch (IOException e) {
            throw new TokenRequestFailedException(e);
        }
        JsonObject responseBodyJson = new JsonParser().parse(JsonSanitizer.sanitize((String)responseBody)).getAsJsonObject();
        String encodedJwt = responseBodyJson.get("access_token").getAsString();
        return encodedJwt;
    }

    private static class CommandSetterBuilder {
        private final Class<? extends Command<?>> commandClass;

        HystrixCommand.Setter build() {
            String groupKey = HystrixUtil.getGlobalKey(this.commandClass);
            String commandKey = "refreshTokenRetrievalCommand";
            HystrixCommandProperties.Setter commandProperties = HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(6000).withCircuitBreakerEnabled(true).withCircuitBreakerSleepWindowInMilliseconds(6000).withFallbackEnabled(false);
            return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)groupKey)).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)"refreshTokenRetrievalCommand")).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(10).withQueueSizeRejectionThreshold(100).withMaxQueueSize(100)).andCommandPropertiesDefaults(commandProperties);
        }

        public CommandSetterBuilder(Class<? extends Command<?>> commandClass) {
            this.commandClass = commandClass;
        }

        public Class<? extends Command<?>> getCommandClass() {
            return this.commandClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandSetterBuilder)) {
                return false;
            }
            CommandSetterBuilder other = (CommandSetterBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<Command<?>> this$commandClass = this.getCommandClass();
            Class<? extends Command<?>> other$commandClass = other.getCommandClass();
            return !(this$commandClass == null ? other$commandClass != null : !this$commandClass.equals(other$commandClass));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CommandSetterBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<Command<?>> $commandClass = this.getCommandClass();
            result = result * 59 + ($commandClass == null ? 43 : $commandClass.hashCode());
            return result;
        }

        public String toString() {
            return "RefreshJwtTokenCommand.CommandSetterBuilder(commandClass=" + this.getCommandClass() + ")";
        }
    }
}

