/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.security.user.LocalScopePrefixProvider;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import javax.annotation.Nonnull;

public class DefaultLocalScopePrefixProvider
implements LocalScopePrefixProvider {
    private ScpCfCloudPlatform getCloudPlatform() {
        CloudPlatform cloudPlatform = CloudPlatformAccessor.getCloudPlatform();
        if (!(cloudPlatform instanceof ScpCfCloudPlatform)) {
            throw new ShouldNotHappenException("The current Cloud platform is not an instance of " + ScpCfCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:core-scp-cf.");
        }
        return (ScpCfCloudPlatform)cloudPlatform;
    }

    @Override
    @Nonnull
    public String getLocalScopePrefix() {
        try {
            DecodedJWT jwt = AuthTokenAccessor.getCurrentToken().orElseThrow(() -> new AuthTokenAccessException("Failed to get access token: no JWT found in current request.")).getJwt();
            JsonObject xsuaaServiceCredentials = this.getCloudPlatform().getXsuaaServiceCredentials(jwt);
            return xsuaaServiceCredentials.get("xsappname").getAsString() + ".";
        }
        catch (CloudPlatformException e) {
            throw new UserAccessException("Failed to get user authorizations.", (Throwable)e);
        }
    }
}

