/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Payload;
import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.Scope;
import com.sap.cloud.sdk.cloudplatform.security.user.DefaultLocalScopePrefixProvider;
import com.sap.cloud.sdk.cloudplatform.security.user.LocalScopePrefixProvider;
import com.sap.cloud.sdk.cloudplatform.security.user.ScopeAccessException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class LocalScopePrefixExtractor {
    private static final Logger logger = CloudLoggerFactory.getLogger(LocalScopePrefixExtractor.class);
    private static final String JWT_SCOPE_CLAIM = "scope";
    private final LocalScopePrefixProvider prefixProvider;

    public LocalScopePrefixExtractor(@Nullable LocalScopePrefixProvider prefixProvider) {
        this.prefixProvider = prefixProvider != null ? prefixProvider : new DefaultLocalScopePrefixProvider();
    }

    @Nonnull
    public Set<Authorization> getAuthorizations(@Nonnull Payload jwt) throws ScopeAccessException {
        List scopeNames;
        HashSet authorizations = Sets.newHashSet();
        try {
            scopeNames = jwt.getClaim(JWT_SCOPE_CLAIM).asList(String.class);
        }
        catch (JWTDecodeException e) {
            throw new ScopeAccessException("Failed to get authorizations.", e);
        }
        String localScopePrefixWithDot = this.getPrefixWithTrailingDot();
        if (scopeNames != null) {
            for (String scopeName : scopeNames) {
                if (scopeName.startsWith(localScopePrefixWithDot)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Adding local scope '" + scopeName + "'.");
                    }
                    authorizations.add(new Scope(scopeName.substring(localScopePrefixWithDot.length())));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Skipping non-local scope '" + scopeName + "'.");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Skipping reading of user authorizations: cannot find field 'scope' in authorization token.");
        }
        return authorizations;
    }

    private String getPrefixWithTrailingDot() {
        String localScopePrefix = this.prefixProvider.getLocalScopePrefix();
        return localScopePrefix.endsWith(".") ? localScopePrefix : localScopePrefix + ".";
    }
}

