/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security;

import javax.annotation.Nonnull;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * {@code Authorization} implementation based on an account Id and another {@code Authorization}.
 */
@EqualsAndHashCode( callSuper = true )
@Data
public class AccountSpecificAuthorization extends Authorization
{
    /**
     * The account identifier.
     */
    @Nonnull
    protected final String accountId;

    /**
     * The wrapped authorization.
     */
    @Nonnull
    protected final Authorization authorization;

    /**
     * Creates a new authorization based on the tenant identifier and another {@code Authorization}.
     *
     * @param accountId
     *            The account identifier of this {@code Authorization}.
     * @param authorization
     *            The {@code Authorization} to be considered tenant-specific.
     */
    public AccountSpecificAuthorization( @Nonnull final String accountId, @Nonnull final Authorization authorization )
    {
        super(accountId + ":" + authorization.getName());

        this.accountId = accountId;
        this.authorization = authorization;
    }
}
