/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.principal;

import java.util.Set;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.user.User;

import lombok.RequiredArgsConstructor;

/**
 * An implementation of the {@code Principal} interface for SAP Cloud Platform Neo.
 */
@RequiredArgsConstructor
public class ScpNeoPrincipal implements Principal
{
    @Nonnull
    private final User delegate;

    @Nonnull
    @Override
    public String getId()
    {
        return delegate.getName();
    }

    @Nonnull
    @Override
    public Set<Authorization> getAuthorizations()
    {
        return delegate.getAuthorizations();
    }

    @Override
    public boolean hasAuthorization( @Nonnull final Authorization authorization )
    {
        return delegate.hasAuthorization(authorization);
    }
}
