/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.principal;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAccessor;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserNotAuthenticatedException;

/**
 * Facade providing access to {@code Principal} information on SAP Cloud Platform Neo.
 */
public class ScpNeoPrincipalFacade implements PrincipalFacade
{
    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public Principal getCurrentPrincipal()
        throws PrincipalAccessException
    {
        final User currentUser;
        try {
            currentUser = UserAccessor.getCurrentUser();
        }
        catch( final UserAccessException | UserNotAuthenticatedException e ) {
            throw new PrincipalAccessException(e);
        }
        return new ScpNeoPrincipal(currentUser);
    }
}
