/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.user;

import java.util.Locale;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UserProvider;

class UserProviderAccessor
{
    @Nonnull
    UserProvider getUserProvider()
        throws UserAccessException
    {
        try {
            return UserManagementAccessor.getUserProvider();
        }
        catch( final PersistenceException e ) {
            throw new UserAccessException("Failed to access UserProvider.", e);
        }
    }

    @Nullable
    com.sap.security.um.user.User getUser( @Nonnull final String name )
        throws UserAccessException
    {
        try {
            return getUserProvider().getUser(name.toLowerCase(Locale.ENGLISH));
        }
        catch( final PersistenceException e ) {
            throw new UserAccessException("Failed to get user.", e);
        }
    }
}
