/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.secret;

import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStore;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.SecretStoreAccessException;
import com.sap.cloud.security.password.PasswordStorage;
import com.sap.cloud.security.password.PasswordStorageException;
import javax.annotation.Nonnull;

public class ScpNeoSecretStore
implements SecretStore {
    @Nonnull
    private final PasswordStorage passwordStorage;
    @Nonnull
    private final String name;

    private ScpNeoSecretStore() {
        this.passwordStorage = new MockedPasswordStorage();
        this.name = "";
    }

    public char[] getSecret() throws SecretStoreAccessException {
        try {
            return this.passwordStorage.getPassword(this.name);
        }
        catch (PasswordStorageException | IllegalArgumentException e) {
            throw new SecretStoreAccessException("Failed to access secret store.", e);
        }
    }

    public ScpNeoSecretStore(@Nonnull PasswordStorage passwordStorage, @Nonnull String name) {
        if (passwordStorage == null) {
            throw new NullPointerException("passwordStorage is marked @NonNull but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.passwordStorage = passwordStorage;
        this.name = name;
    }

    private static class MockedPasswordStorage
    implements PasswordStorage {
        private MockedPasswordStorage() {
        }

        public char[] getPassword(String s) throws PasswordStorageException {
            return null;
        }

        public void setPassword(String s, char[] chars) throws PasswordStorageException {
        }

        public void deletePassword(String s) throws PasswordStorageException {
        }
    }
}

