/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.secret;

import com.sap.cloud.crypto.keystore.api.KeyStoreService;
import com.sap.cloud.crypto.keystore.api.KeyStoreServiceException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.secret.AbstractSecretStoreFacade;
import com.sap.cloud.sdk.cloudplatform.security.secret.ScpNeoSecretStore;
import com.sap.cloud.sdk.cloudplatform.security.secret.ScpNeoSecretStoreRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStore;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.KeyStoreAccessException;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.SecretStoreAccessException;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextExecutor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import com.sap.cloud.security.password.PasswordStorage;
import com.sap.cloud.security.password.PasswordStorageException;
import java.security.KeyStore;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class ScpNeoSecretStoreFacade
extends AbstractSecretStoreFacade {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpNeoSecretStoreFacade.class);

    private PasswordStorage getPasswordStorage() throws SecretStoreAccessException {
        Optional requestContext = RequestContextAccessor.getCurrentRequestContext();
        if (!requestContext.isPresent()) {
            throw new SecretStoreAccessException("Failed to get " + PasswordStorage.class.getSimpleName() + ": no " + RequestContext.class.getSimpleName() + " available. Have you correctly configured a " + RequestContextServletFilter.class.getSimpleName() + " or have you wrapped your logic in a " + RequestContextExecutor.class.getSimpleName() + " when executing background tasks that are not triggered by a request?");
        }
        try {
            Optional property = ((RequestContext)requestContext.get()).getProperty(ScpNeoSecretStoreRequestContextListener.PROPERTY_PASSWORD_STORAGE);
            if (!property.isPresent()) {
                throw new SecretStoreAccessException("Failed to get " + PasswordStorage.class.getSimpleName() + ": " + RequestContext.class.getSimpleName() + " property '" + ScpNeoSecretStoreRequestContextListener.PROPERTY_PASSWORD_STORAGE + "' is not present. Please ensure that " + ScpNeoSecretStoreRequestContextListener.class.getSimpleName() + " is available on the class path.");
            }
            Exception exception = ((Property)property.get()).getException();
            if (exception != null) {
                throw new SecretStoreAccessException("Failed to get " + PasswordStorage.class.getSimpleName() + ".", (Throwable)exception);
            }
            return (PasswordStorage)((Property)property.get()).getValue();
        }
        catch (RequestContextPropertyException e) {
            throw new SecretStoreAccessException("Failed to get " + PasswordStorage.class.getSimpleName() + ": failed to get " + RequestContext.class.getSimpleName() + " property.", (Throwable)e);
        }
    }

    private KeyStoreService getKeyStoreService() throws KeyStoreAccessException {
        Optional requestContext = RequestContextAccessor.getCurrentRequestContext();
        if (!requestContext.isPresent()) {
            throw new KeyStoreAccessException("Failed to get " + KeyStoreService.class.getSimpleName() + ": no " + RequestContext.class.getSimpleName() + " available. Have you correctly configured a " + RequestContextServletFilter.class.getSimpleName() + " or have you wrapped your logic in a " + RequestContextExecutor.class.getSimpleName() + " when executing background tasks that are not triggered by a request?");
        }
        try {
            Optional property = ((RequestContext)requestContext.get()).getProperty(ScpNeoSecretStoreRequestContextListener.PROPERTY_KEY_STORE_SERVICE);
            if (!property.isPresent()) {
                throw new KeyStoreAccessException("Failed to get " + KeyStoreService.class.getSimpleName() + ": " + RequestContext.class.getSimpleName() + " property '" + ScpNeoSecretStoreRequestContextListener.PROPERTY_KEY_STORE_SERVICE + "' is not present. Please ensure that " + ScpNeoSecretStoreRequestContextListener.class.getSimpleName() + " is available on the class path.");
            }
            Exception exception = ((Property)property.get()).getException();
            if (exception != null) {
                throw new KeyStoreAccessException("Failed to get " + KeyStoreService.class.getSimpleName() + ".", (Throwable)exception);
            }
            return (KeyStoreService)((Property)property.get()).getValue();
        }
        catch (RequestContextPropertyException e) {
            throw new KeyStoreAccessException("Failed to get " + KeyStoreService.class.getSimpleName() + ": failed to get " + RequestContext.class.getSimpleName() + " property.", (Throwable)e);
        }
    }

    @Nonnull
    public Class<? extends SecretStore> getSecretStoreClass() {
        return ScpNeoSecretStore.class;
    }

    @Nonnull
    public Optional<SecretStore> getSecretStoreIfPresent(String name) throws SecretStoreAccessException {
        PasswordStorage passwordStorage = this.getPasswordStorage();
        try {
            if (passwordStorage.getPassword(name) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No secret store found with name '" + name + "'.");
                }
                return Optional.empty();
            }
        }
        catch (PasswordStorageException | IllegalArgumentException e) {
            throw new SecretStoreAccessException("Failed to access secret store.", e);
        }
        return Optional.of(new ScpNeoSecretStore(passwordStorage, name));
    }

    @Nonnull
    public Optional<KeyStore> getKeyStoreIfPresent(String name, SecretStore password) throws KeyStoreAccessException {
        KeyStoreService keyStoreService = this.getKeyStoreService();
        if (!keyStoreService.getKeyStoreNames().contains(name)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No key store found with name '" + name + "'.");
            }
            return Optional.empty();
        }
        try {
            return Optional.of(keyStoreService.getKeyStore(name, password.getSecret()));
        }
        catch (KeyStoreServiceException e) {
            throw new KeyStoreAccessException("Failed to access key store.", (Throwable)e);
        }
    }
}

