/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.secret;

import com.sap.cloud.sdk.cloudplatform.exception.ObjectLookupFailedException;
import com.sap.cloud.sdk.cloudplatform.naming.JndiLookupAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.AbstractRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class ScpNeoSecretStoreRequestContextListener
extends AbstractRequestContextListener {
    public static final String PROPERTY_PASSWORD_STORAGE = ScpNeoSecretStoreRequestContextListener.class.getName() + ":passwordStorage";
    public static final String PROPERTY_KEY_STORE_SERVICE = ScpNeoSecretStoreRequestContextListener.class.getName() + ":keyStoreService";
    private static final String JNDI_NAME_PASSWORD_STORAGE = "java:comp/env/PasswordStorage";
    private static final String JNDI_NAME_KEY_STORE_SERVICE = "java:comp/env/KeyStoreService";

    public int getPriority() {
        return 3;
    }

    @Nonnull
    protected Map<String, Property<?>> getProperties(@Nonnull RequestContext requestContext) {
        Property keyStoreService;
        Property passwordStorage;
        HashMap properties = new HashMap();
        try {
            passwordStorage = Property.ofConfidentialValue((Object)JndiLookupAccessor.lookup((String)JNDI_NAME_PASSWORD_STORAGE));
            keyStoreService = Property.ofConfidentialValue((Object)JndiLookupAccessor.lookup((String)JNDI_NAME_KEY_STORE_SERVICE));
        }
        catch (ObjectLookupFailedException e) {
            passwordStorage = Property.ofConfidentialException((Exception)((Object)e));
            keyStoreService = Property.ofConfidentialException((Exception)((Object)e));
        }
        properties.put(PROPERTY_PASSWORD_STORAGE, passwordStorage);
        properties.put(PROPERTY_KEY_STORE_SERVICE, keyStoreService);
        return properties;
    }
}

