/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.servlet;

import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLogger;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.security.auth.login.LoginContextFactory;
import java.io.IOException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;

public class AuthContextFilter
implements Filter {
    private static final Logger logger = CloudLoggerFactory.getLogger(AuthContextFilter.class);
    private static final String INIT_PARAMETER_AUTH_METHOD = "method";
    private String authMethod = null;

    public void init(FilterConfig filterConfig) {
        this.authMethod = filterConfig.getInitParameter(INIT_PARAMETER_AUTH_METHOD);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        block8: {
            if (!(servletResponse instanceof HttpServletResponse)) {
                return;
            }
            if (!(servletRequest instanceof HttpServletRequest)) {
                return;
            }
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            HttpServletResponse resp = (HttpServletResponse)servletResponse;
            String user = req.getRemoteUser();
            if (user != null) {
                filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            } else {
                try {
                    if (this.authMethod == null) {
                        throw new ShouldNotHappenException("Authorization filter misconfiguration: missing authentication method. Please specify the initialization parameter 'method'.");
                    }
                    HttpSession session = req.getSession(false);
                    if (session != null) {
                        session.invalidate();
                    }
                    LoginContext loginContext = LoginContextFactory.createLoginContext((String)this.authMethod);
                    loginContext.login();
                    filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
                }
                catch (LoginException e) {
                    resp.setStatus(401);
                    AuditLogger.logSecurityEvent((String)("Unauthorized login attempt. Message: " + e.getMessage() + "."), null);
                    if (!logger.isWarnEnabled()) break block8;
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void destroy() {
    }
}

