/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.servlet;

import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpNeoCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLogger;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.tenant.ScpNeoTenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class ProviderAccountFilter
implements Filter {
    private static final Logger logger = CloudLoggerFactory.getLogger(ProviderAccountFilter.class);

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof HttpServletResponse)) {
            return;
        }
        if (!(request instanceof HttpServletRequest)) {
            return;
        }
        HttpServletResponse resp = (HttpServletResponse)response;
        ScpNeoTenant tenant = (ScpNeoTenant)TenantAccessor.getCurrentTenant();
        String accountId = tenant.getTenantContext().getTenant().getAccount().getId();
        CloudPlatform cloudPlatform = CloudPlatformAccessor.getCloudPlatform();
        if (!(cloudPlatform instanceof ScpNeoCloudPlatform)) {
            throw new ShouldNotHappenException("The current Cloud platform is not an instance of " + ScpNeoCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:core-scp-neo.");
        }
        ScpNeoCloudPlatform scpNeoCloudPlatform = (ScpNeoCloudPlatform)cloudPlatform;
        if (scpNeoCloudPlatform.getProviderAccountId().equals(accountId)) {
            chain.doFilter(request, response);
        } else {
            resp.setStatus(401);
            String message = "Unauthorized attempt to access resource that must only be accessed from within provider account.";
            AuditLogger.logSecurityEvent((String)"Unauthorized attempt to access resource that must only be accessed from within provider account.", null);
            logger.error("Unauthorized attempt to access resource that must only be accessed from within provider account.");
        }
    }

    public void destroy() {
    }
}

