/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.Role;
import com.sap.cloud.sdk.cloudplatform.security.user.AbstractUser;
import com.sap.cloud.sdk.cloudplatform.security.user.StringUserAttribute;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAttribute;
import com.sap.cloud.sdk.cloudplatform.security.user.UserProviderAccessor;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.security.um.user.PasswordCheckResult;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.User;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ScpNeoUser
extends AbstractUser {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpNeoUser.class);
    public static final String FIRST_NAME = "firstname";
    public static final String LAST_NAME = "lastname";
    public static final String EMAIL = "email";
    private static final Function<String, Authorization> transformRole = new Function<String, Authorization>(){

        @Override
        @Nullable
        public Authorization apply(@Nullable String roleName) {
            if (roleName == null) {
                return null;
            }
            return new Role(roleName);
        }
    };
    @Nonnull
    static UserProviderAccessor userProviderAccessor = new UserProviderAccessor();
    @Nonnull
    private final User delegate;

    public ScpNeoUser(@Nonnull User delegate) {
        super(delegate.getName().toLowerCase(Locale.ENGLISH), delegate.getLocale(), Collections.emptySet(), Collections.emptyMap());
        this.delegate = delegate;
    }

    @Nullable
    static ScpNeoUser ofCurrentUser(@Nonnull String name) throws UserAccessException {
        User delegate = userProviderAccessor.getUser(name);
        if (delegate == null) {
            return null;
        }
        return new ScpNeoUser(delegate);
    }

    static ScpNeoUser ofMockedUser() {
        return new ScpNeoUser();
    }

    private ScpNeoUser() {
        this(new MockedUser());
    }

    public boolean hasAuthorization(@Nonnull Authorization authorization) {
        return this.delegate.hasRole(authorization.getName());
    }

    @Nonnull
    public Set<Authorization> getAuthorizations() {
        return this.delegate.getRoles().stream().map(transformRole).collect(Collectors.toSet());
    }

    @Nonnull
    public Optional<UserAttribute> getAttribute(@Nonnull String name) {
        try {
            String attribute = this.delegate.getAttribute(name);
            if (attribute == null) {
                return Optional.empty();
            }
            StringUserAttribute userAttribute = new StringUserAttribute(name, attribute);
            return Optional.of(userAttribute);
        }
        catch (UnsupportedUserAttributeException e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to get user attribute " + name + ".", (Throwable)e);
            }
            return Optional.empty();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScpNeoUser)) {
            return false;
        }
        ScpNeoUser other = (ScpNeoUser)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScpNeoUser;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        return "ScpNeoUser(super=" + super.toString() + ", delegate=" + this.getDelegate() + ")";
    }

    @Nonnull
    public User getDelegate() {
        return this.delegate;
    }

    private static class MockedUser
    implements User {
        private MockedUser() {
        }

        public PasswordCheckResult checkPassword(char[] chars) {
            return PasswordCheckResult.FAILED_UNKNOWN_REASON;
        }

        public String getAttribute(String s) {
            return null;
        }

        public Set<String> listAttributes() {
            return Collections.emptySet();
        }

        public Locale getLocale() {
            return null;
        }

        public boolean hasRole(String s) {
            return false;
        }

        public boolean isValid(Calendar calendar) {
            return false;
        }

        public Set<String> getRoles() {
            return Collections.emptySet();
        }

        public String[] getAttributeValues(String s) {
            return null;
        }

        public Set<String> getGroups() {
            return Collections.emptySet();
        }

        public String getName() {
            return "";
        }
    }
}

