/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.sap.cloud.sdk.cloudplatform.WithRuntimeDependencies;
import com.sap.cloud.sdk.cloudplatform.exception.DependencyNotFoundException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.user.AbstractUserFacade;
import com.sap.cloud.sdk.cloudplatform.security.user.ScpNeoUser;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessDeniedException;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextExecutor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;

public class ScpNeoUserFacade
extends AbstractUserFacade
implements WithRuntimeDependencies {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpNeoUserFacade.class);

    @Nonnull
    public Class<ScpNeoUser> getUserClass() {
        return ScpNeoUser.class;
    }

    @Nonnull
    protected User newMockedUser() {
        return ScpNeoUser.ofMockedUser();
    }

    @Nonnull
    private String getUserName(HttpServletRequest request) {
        return request.getUserPrincipal().getName().toLowerCase(Locale.ENGLISH);
    }

    @Nullable
    private String getCurrentUserName() throws UserAccessException {
        Optional requestContext = RequestContextAccessor.getCurrentRequestContext();
        if (!requestContext.isPresent()) {
            throw new UserAccessException("Failed to get current user name: no " + RequestContext.class.getSimpleName() + " available. Have you correctly configured a " + RequestContextServletFilter.class.getSimpleName() + " or have you wrapped your logic in a " + RequestContextExecutor.class.getSimpleName() + " when executing background tasks that are not triggered by a request?");
        }
        Optional request = ((RequestContext)requestContext.get()).getRequest();
        if (!request.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to get current user: no request available. This is expected when trying to obtain the current user within tasks that are not triggered by a request, for example, while using a " + RequestContextExecutor.class.getSimpleName() + ".");
            }
            return null;
        }
        if (((HttpServletRequest)request.get()).getUserPrincipal() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to get user name from request: user principal is null.");
            }
            return null;
        }
        return this.getUserName((HttpServletRequest)request.get());
    }

    public void assertRuntimeDependenciesExist() throws DependencyNotFoundException {
        try {
            Class.forName("com.sap.security.um.user.User");
            Class.forName("com.sap.security.um.service.UserManagementAccessor");
        }
        catch (ClassNotFoundException e) {
            throw new DependencyNotFoundException("Failed to instantiate User. Please make sure to use the local SAP Cloud Platform Neo runtime. If you require another container for local deployment, make sure to add the latest version of one of the following dependencies to your project: 'com.sap.cloud:neo-java-web-api' for a Tomcat container or 'com.sap.cloud:neo-javaee7-wp-api' for a Java EE container such as TomEE. Note that this requires separate Maven profiles: a profile for local development that uses the respective dependency with scope 'compile' and a profile for deployment on SAP Cloud Platform Neo that uses scope 'provided'.", (Throwable)e);
        }
    }

    @Nonnull
    public Optional<User> resolveCurrentUser() throws UserAccessException {
        this.assertRuntimeDependenciesExist();
        Optional mockedUser = this.getMockedUser();
        if (mockedUser.isPresent()) {
            return mockedUser;
        }
        String name = this.getCurrentUserName();
        if (name == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ScpNeoUser.ofCurrentUser(name));
    }

    @Nonnull
    public Optional<User> getUserByName(@Nullable String name) throws UserAccessDeniedException, UserAccessException {
        this.assertRuntimeDependenciesExist();
        if (name == null) {
            return Optional.empty();
        }
        Optional mockedUser = this.getMockedUser();
        if (mockedUser.isPresent() && name.equals(((User)mockedUser.get()).getName())) {
            return mockedUser;
        }
        return Optional.ofNullable(ScpNeoUser.ofCurrentUser(name));
    }
}

