/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class UserProviderAccessor {
    UserProviderAccessor() {
    }

    @Nonnull
    UserProvider getUserProvider() throws UserAccessException {
        try {
            return UserManagementAccessor.getUserProvider();
        }
        catch (PersistenceException e) {
            throw new UserAccessException("Failed to access UserProvider.", (Throwable)e);
        }
    }

    @Nullable
    User getUser(@Nonnull String name) throws UserAccessException {
        try {
            return this.getUserProvider().getUser(name.toLowerCase(Locale.ENGLISH));
        }
        catch (PersistenceException e) {
            throw new UserAccessException("Failed to get user.", (Throwable)e);
        }
    }
}

