/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.servlet;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

/**
 * Rejects non-{@link HttpServletResponse} responses and extends the header with some security settings.
 */
public class HttpSecurityHeadersFilter implements Filter
{
    @Override
    public void init( final FilterConfig filterConfig )
        throws ServletException
    {

    }

    @Override
    public void doFilter( final ServletRequest request, final ServletResponse response, final FilterChain chain )
        throws IOException,
            ServletException
    {
        if( !(response instanceof HttpServletResponse) ) {
            return;
        }

        final HttpServletResponse resp = (HttpServletResponse) response;
        resp.setHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains");
        resp.setHeader("X-Frame-Options", "SAMEORIGIN");

        chain.doFilter(request, response);
    }

    @Override
    public void destroy()
    {

    }
}
